package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.event.EventManager;
import com.stringee.messaging.ChannelType;
import com.stringee.messaging.ChatRequest;
import com.stringee.messaging.ChatRequest.RequestType;
import com.stringee.messaging.User;
import com.stringee.network.tcpclient.packet.Packet;

public class TransferChatFromServer extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            String convId = packet.optFieldString("convId", null);
            String customerId = packet.optFieldString("customerId", null);
            String name = packet.optFieldString("customerName", null);
            ChannelType channelType = ChannelType.getType(packet.optFieldInt("channelType"));
            String from = packet.optFieldString("from", null);
            String fromName = packet.optFieldString("fromUsername", null);
            String fromAvatar = packet.optFieldString("fromAvatar", null);

            ChatRequest chatRequest = new ChatRequest();
            chatRequest.setConvId(convId);
            chatRequest.setCustomerId(customerId);
            chatRequest.setUserId(client.getUserId());
            chatRequest.setName(name);
            chatRequest.setChannelType(channelType);
            chatRequest.setRequestType(RequestType.TRANSFER);

            User fromUser = new User(from);
            fromUser.setName(fromName);
            fromUser.setAvatarUrl(fromAvatar);

            client.getChatRequestMap().put(convId, chatRequest);
            EventManager.sendChatSupportReceiceEvent(client, chatRequest);
        });
    }
}
