package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.call.StringeeCall2;
import com.stringee.call.StringeeCall2.EndCallCause;
import com.stringee.call.StringeeCall2.SignalingState;
import com.stringee.common.StringeeConstant;
import com.stringee.listener.StatusListener;
import com.stringee.network.tcpclient.packet.Packet;
import com.stringee.video.StringeeRoom;

public class VideoEndCallFromServer extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            String callId = packet.optFieldString("callId");
            StringeeCall2 stringeeCall2 = client.getCallMap2().get(callId);
            if (stringeeCall2 != null) {
                if (stringeeCall2.getState() != SignalingState.BUSY) {
                    stringeeCall2.setState(SignalingState.ENDED);
                    stringeeCall2.setCallStatus(StringeeConstant.SIP_CODE_ENDED);
                    StringeeCall2.StringeeCallListener callListener = stringeeCall2.getCallListener();
                    String endReason = packet.optFieldString("endCallCause", "NORMAL");
                    switch (endReason) {
                        case "NORMAL":
                            endReason = EndCallCause.NORMAL.getValue();
                            break;
                        case "NOT_ENOUGH_MONEY":
                            endReason = EndCallCause.NOT_ENOUGH_MONEY.getValue();
                            break;
                        case "MAX_CONNECT_TIME":
                            endReason = EndCallCause.MAX_CONNECT_TIME.getValue();
                            break;
                        case "TIMEOUT_CLOSE_CONNECTION":
                            endReason = EndCallCause.TIMEOUT_CLOSE_CONNECTION.getValue();
                            break;
                        case "486 Busy Here":
                            endReason = EndCallCause.USER_BUSY.getValue();
                            break;
                        case "USER_END_CALL":
                            endReason = EndCallCause.USER_END_CALL.getValue();
                            break;
                        case "487 Request Terminated":
                            endReason = EndCallCause.USER_CANCEL.getValue();
                            break;
                        case "TIMEOUT_WAIT_SDP_TO_MAKECALL":
                            endReason = EndCallCause.TIMEOUT_WAIT_SDP_TO_MAKE_CALL.getValue();
                            break;
                        case "CAN_NOT_MAKE_CALL":
                            endReason = EndCallCause.CAN_NOT_MAKE_CALL.getValue();
                            break;
                        case "480 Temporarily Unavailable":
                            endReason = EndCallCause.USER_TEMPORARILY_UNAVAILABLE.getValue();
                            break;
                        case "TIMEOUT_MAKECALL":
                            endReason = EndCallCause.TIMEOUT_MAKE_CALL.getValue();
                            break;
                        case "TIMEOUT_ANSWER":
                            endReason = EndCallCause.TIMEOUT_ANSWER.getValue();
                            break;
                        case "DTMF_END":
                            endReason = EndCallCause.DTMF_END.getValue();
                            break;
                        case "VOICE_MAIL_END":
                            endReason = EndCallCause.VOICE_MAIL_END.getValue();
                            break;
                        case "USER_MAKE_ANOTHER_CALL":
                            endReason = EndCallCause.USER_MAKE_ANOTHER_CALL.getValue();
                            break;
                        case "REST_API_STOP":
                            endReason = EndCallCause.REST_API_STOP.getValue();
                            break;
                        case "STRINGEE_CLIENT_DISCONNECTED":
                            endReason = EndCallCause.STRINGEE_CLIENT_DISCONNECTED.getValue();
                            break;
                        case "UNKOWN":
                            endReason = EndCallCause.UNKNOWN.getValue();
                            break;
                        case "CALL_NOT_EXIST_IN_SERVER":
                            endReason = EndCallCause.CALL_NOT_EXIST_IN_SERVER.getValue();
                            break;
                    }
                    if (callListener != null) {
                        callListener.onSignalingStateChange(stringeeCall2, SignalingState.ENDED, endReason, -1, "");
                    }
                }
                StringeeRoom room = stringeeCall2.getRoom();
                if (room != null) {
                    room.leave(true, new StatusListener() {
                        @Override
                        public void onSuccess() {

                        }
                    });
                }
                stringeeCall2.release();
            }
        });
    }
}