package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.call.StringeeCall2;
import com.stringee.call.StringeeCall2.EndCallCause;
import com.stringee.common.StringeeConstant;
import com.stringee.common.Utils;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;

public class VideoRoomCallCancel extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            try {
                String roomId = packet.getFieldString("roomId");
                String callId = packet.optFieldString("callId");
                StringeeCall2 call = client.getCallMap2().get(callId);
                if (call == null) {
                    return;
                }
                call.setCallStatus(StringeeConstant.SIP_CODE_ENDED);
                call.setState(StringeeCall2.SignalingState.ENDED);
                StringeeCall2.StringeeCallListener listener = call.getCallListener();
                if (listener != null) {
                    listener.onSignalingStateChange(call, StringeeCall2.SignalingState.ENDED, EndCallCause.NORMAL.getValue(), -1, "");
                }
                call.release();
            } catch (JSONException e) {
                Utils.reportException(VideoRoomCallCancel.class, e);
            }

        });
    }
}
