package com.stringee.network.processor;

import android.util.Log;

import com.stringee.StringeeClient;
import com.stringee.call.CallType;
import com.stringee.call.StringeeCall2;
import com.stringee.common.Utils;
import com.stringee.common.event.EventManager;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;
import org.json.JSONObject;

public class VideoRoomCallInvite extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            try {
                String callId = packet.optFieldString("callId");
                StringeeCall2 call = client.getCallMap2().get(callId);
                if (call != null) {
                    Log.d("Stringee", "StringeeCall exists");
                    return;
                }

                String from = packet.getFieldString("fromNumber");
                String to = packet.getFieldString("toNumber");
                boolean video = packet.optFieldBoolean("video", false);
                String fromAlias = packet.optFieldString("fromAlias", "");
                String toAlias = packet.optFieldString("toAlias", "");
                String customDataFromYourServer = packet.optFieldString("customDataFromYourServer", "");
                String roomId = packet.getFieldString("roomId");
                String roomToken = packet.getFieldString("roomToken");
                JSONObject encryptPhoneObj = packet.optFieldJSONObject("encryptPhone");
                String encryptPhone = "";
                if (encryptPhoneObj != null) {
                    encryptPhone = encryptPhoneObj.optString("from", "");
                }

                StringeeCall2 stringeeCall = new StringeeCall2(client, callId, from, to);
                stringeeCall.setVideoCall(video);
                stringeeCall.setFromAlias(fromAlias);
                stringeeCall.setToAlias(toAlias);
                stringeeCall.setCallType(CallType.APP_TO_APP_INCOMING);
                stringeeCall.setRoomId(roomId);
                stringeeCall.setRoomToken(roomToken);
                stringeeCall.setCustomDataFromYourServer(customDataFromYourServer);
                stringeeCall.setEncryptNumber(encryptPhone);
                EventManager.sendClientIncomingCall2Event(client, stringeeCall);
            } catch (JSONException e) {
                Utils.reportException(VideoRoomCallInvite.class, e);
            }
        });
    }
}
