package com.stringee.network.tcpclient;

import com.stringee.common.Common;
import com.stringee.common.Utils;

public class CheckTimeOutThread extends Thread {

    private boolean isRunning = false;
    private TcpClient tcpClient;

    public CheckTimeOutThread() {
    }

    public void setTcpClient(TcpClient tcpClient) {
        this.tcpClient = tcpClient;
    }

    @Override
    public void run() {
        isRunning = true;
        while (isRunning) {
            checkNetwork();
            try {
                Thread.sleep(15000);
            } catch (InterruptedException | IllegalArgumentException e) {
                Utils.reportException(CheckTimeOutThread.class, e);
            }
        }
    }

    private void checkNetwork() {
        if (tcpClient != null
                && tcpClient.isConnected()) {
            long time = System.currentTimeMillis()
                    - tcpClient.getLastPacketReceivedTime();
            if (time > (Common.pingAfterMs + 15000)) {
                tcpClient.disconnect();
            }
        }
    }

    public boolean isRunning() {
        return isRunning;
    }

    public void setRunning(boolean isRunning) {
        this.isRunning = isRunning;
    }

}
