package com.stringee.network.tcpclient.packet;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Alex
 */

public enum ServiceType {
    PING(1),
    AUTHEN(2),
    CALLOUT_START_CALL(3),
    CALLOUT_CALL_DATA(4),
    CALLOUT_STOP_CALL(5),
    CALLOUT_STATUS_CHANGE(6),
    CALLOUT_DATA_FROM_GATEWAY(7),
    VIDEO_CONFERENCE_MAKE_ROOM(8),
    VIDEO_CONFERENCE_JOIN_ROOM(9),
    VIDEO_CONFERENCE_JOIN_ROOM_NOTIFICATION(10),
    VIDEO_CONFERENCE_LEAVE_ROOM_NOTIFICATION(11),
    VIDEO_CONFERENCE_LEAVE_ROOM(12),
    VIDEO_CONFERENCE_STREAM_ADDED(15),
    VIDEO_CONFERENCE_STREAM_REMOVED(16),
    VIDEO_CONFERENCE_TERMINATE_ROOM(17),
    VIDEO_CONFERENCE_TERMINATE_ROOM_NOTIFICATION(18),
    CALL_START(26),//client -> server
    CALL_SDP_CANDIDATE(27),//client -> server
    CALL_STOP(28),//client -> server
    CALL_SDP_CANDIDATE_FROM_SERVER(29),//server -> client
    CALL_STOP_FROM_SERVER(30),//server -> client
    CALL_STATE(31),//client -> server
    CALL_STATE_FROM_SERVER(32),//server -> client
    CALL_START_FROM_SERVER(33),//server -> client
    CALL_DTMF(34),
    CALL_DTMF_FROM_SERVER(35),
    CALL_INFO(36),
    CALL_INFO_FROM_SERVER(37),
    MSG_FROM_OTHER_DEVICE(38),
    PUSH_DEVICE_TOKEN_REGISTER(39),
    PUSH_DEVICE_TOKEN_UNREGISTER(40),
    CUSTOM_MESSAGE(54),
    CUSTOM_MESSAGE_FROM_SERVER(55),
    GET_MESSAGES_INFO(80),
    HOLD(100),
    TRANSFER_CALL(101),
    SUBSCRIBE_FROM_SERVER(102),
    CHANGE_ATTRIBUTE(103),
    CHAT_CREATE_CONVERSATION(41),
    CHAT_MESSAGE(42),
    CHAT_MESSAGE_FROM_SERVER(45),
    CHAT_MESSAGE_REPORT(46),
    CHAT_MESSAGE_REPORT_FROM_SERVER(47),
    CHAT_CONVERSATION_LOAD(48),
    CHAT_MESSAGE_LOAD(50),
    CHAT_DELETE_CONVERSATION(52),
    GET_USER_INFO(56),
    GET_CONVERSATION(57),
    ADD_PARTICIPANTS(58),
    REMOVE_PARTICIPANTS(60),
    CHAT_REMOVE_PARTICIPANT_FROM_SERVER(61),
    DELETE_MESSAGES(62),
    UPDATE_CONVERSATION(63),
    CHAT_ROUTE_TO_AGENT(64),
    CHAT_AGENT_RESPONSE(65),
    TIMEOUT_ROUTE_TO_AGENT(66),
    TIMEOUT_ROUTE_TO_QUEUE(67),
    END_CHAT(68),
    RATE_CHAT(69),
    CHAT_USER_UPDATE_INFO(70),
    CHAT_SEND_TRANSCRIPT(71),
    CHAT_CONVERSATION_FOR_USERS(75),
    CHAT_UNREAD_CONVERSATION_COUNT(76),
    CHAT_TRANSFER(77),
    CHAT_TRANSFER_RESPONSE(78),
    CHAT_TRANSFER_FROM_SERVER(79),
    AGENT_CONTINUE_CHATTING(82),
    CHAT_USER_BEGIN_TYPING(84),
    CHAT_USER_END_TYPING(85),
    CHAT_USER_BEGIN_TYPING_NOTIFICATION(86),
    CHAT_USER_END_TYPING_NOTIFICATION(87),
    CHAT_PIN_MESSAGE(88),
    CHAT_PIN_MESSAGE_FROM_SERVER(89),
    CHAT_EDIT_MESSAGE(90),
    CHAT_EDIT_MESSAGE_FROM_SERVER(91),
    CHAT_REVOKE_MESSAGE(92),
    CHAT_REVOKE_MESSAGE_FROM_SERVER(93),
    CHAT_CONVERSATION_ATTACHMENT(95),
    CHAT_SET_ROLE(96),
    CHAT_CONVERSATION_ENDED_NOTIFICATION(98),
    CHAT_REQUEST_LOAD(99),
    CHAT_BLOCK_USER(105),
    CHAT_JOIN_OA_CONVERSATION(200),
    VIDEO_ENDPOINT_SDP(108),
    VIDEO_ENDPOINT_CANDIDATE(109),
    VIDEO_ENDPOINT_SDP_FROM_SERVER(110),
    VIDEO_ENDPOINT_CANDIDATE_FROM_SERVER(111),
    VIDEO_ENDPOINT_MAKE_ROOM(112),
    VIDEO_ENDPOINT_JOIN_ROOM(115),
    VIDEO_LEFT_ROOM(116),
    VIDEO_PUBLISH_TRACK(117),
    VIDEO_UNPUBLISH_TRACK(118),
    VIDEO_SUBSCRIBE_TRACK(119),
    VIDEO_UNSUBSCRIBE_TRACK(120),
    //notifi
    VIDEO_TRACK_ADDED_FROM_SERVER(121),//co 1 ai do publish track len room
    VIDEO_TRACK_REMOVED_FROM_SERVER(122),//1 track bi xoa khoi room
    VIDEO_ROOM_JOINED_FROM_SERVER(124),//ai do join room
    VIDEO_ROOM_LEFT_FROM_SERVER(125),//ai do left room

    VIDEO_ROOM_SEND_MSG(126),
    VIDEO_ROOM_MSG_FROM_SERVER(127),
    VIDEO_ROOM_MAKE_CALL(128),
    VIDEO_ROOM_CALL_INVITE(129),
    VIDEO_ROOM_CALL_INVITE_CANCEL(130),
    VIDEO_ROOM_CALL_STATE(131),
    VIDEO_ROOM_END_CALL(132),
    VIDEO_ROOM_END_CALL_FROM_SERVER(133),
    VIDEO_ROOM_CALL_STATE_FROM_SERVER(134),

    VIDEO_ROOM_ENABLE_DISABLE_AUDIO_VIDEO(138),
    VIDEO_ROOM_ENABLE_DISABLE_AUDIO_VIDEO_FROM_SERVER(139),
    VIDEO_ROOM_ENABLE_DISABLE_AUDIO_VIDEO_NOTIFICATION(140),
    VIDEO_ROOM_MEDIA_STATE (143),
    CALL_DTMF2(145),
    CHECK_EXIST_CALL(205),
    XCHAT_LOAD_CUSTOMER_CONVERSATION_LIST(206),
    XCHAT_LOAD_CONVERSATION(207),
    XCHAT_LOAD_MESSAGE(208),
    XCHAT_GET_CONVERSATION_INFO(209);

    static final Map<Integer, ServiceType> listType = new HashMap<>();

    static {
        final ServiceType[] serviceTypes = ServiceType.values();
        for (ServiceType serviceType : serviceTypes) {
            listType.put((int) serviceType.getValue(), serviceType);
        }
    }

    private final short value;

    public static ServiceType getServiceType(short value) {
        return listType.get((int) value);
    }

    ServiceType(final int value) {
        this.value = (short) value;
    }

    public short getValue() {
        return value;
    }
}
