package com.stringee.network.tcpclient.ssl;

import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

/**
 * @author Alex
 */

public class MyHostnameVerifier implements HostnameVerifier {

    private boolean developement;

    public MyHostnameVerifier(boolean developement) {
        this.developement = developement;
    }

    /**
     * Checks if a given hostname matches the certificate or principal of a given session.
     */
    private boolean hostnameMatches(String hostname, SSLSession session) {
        if (developement) {
            return true;
        }

        SunHostnameChecker checker = new SunHostnameChecker();

        boolean validCertificate = false;
        boolean validPrincipal = false;

        //test
        try {
            Certificate[] peerCertificates = session.getPeerCertificates();

            if (peerCertificates.length > 0 && peerCertificates[0] instanceof X509Certificate) {
                X509Certificate peerCertificate = (X509Certificate) peerCertificates[0];

                try {
                    checker.match(hostname, peerCertificate);
                    // Certificate matches hostname
                    validCertificate = true;
                } catch (CertificateException ex) {
                    // Certificate does not match hostname
                }
            } else {
                // Peer does not have any certificates or they aren't X.509
            }
        } catch (SSLPeerUnverifiedException ex) {
            // Not using certificates for peers, try verifying the principal
            simpleVerifyingPrincipal(hostname, session, checker);
        }

        return validCertificate || validPrincipal;
    }

    private boolean simpleVerifyingPrincipal(String hostname, SSLSession session, SunHostnameChecker checker) {
        boolean validPrincipal = false;
        try {
            Principal peerPrincipal = session.getPeerPrincipal();
            String[] tmp1 = peerPrincipal.getName().split(",");

            String domain = null;
            for (String item : tmp1) {
                String[] tmp2 = item.split("=");
                if (tmp2.length == 2) {
                    if (tmp2[0].equalsIgnoreCase("CN")) {
                        domain = tmp2[1];
                    }
                }
            }

            if (domain != null) {
                validPrincipal = checker.isMatched(hostname, domain);
            }
        } catch (SSLPeerUnverifiedException ex1) {
            Logger.getLogger(MyHostnameVerifier.class.getName()).log(Level.SEVERE, null, ex1);
        }

        return validPrincipal;
    }

    @Override
    public boolean verify(String hostname, SSLSession session) {
        return hostnameMatches(hostname, session);
    }

}
