package com.stringee.network.tcpclient.ssl;

import android.annotation.SuppressLint;

import com.stringee.common.Utils;
import com.stringee.network.tcpclient.StringeeCertificate;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SSLManager {
    private final List<StringeeCertificate> certificates;
    private final boolean trustAll;

    public SSLManager(List<StringeeCertificate> certificates, boolean trustAll) {
        this.certificates = certificates;
        this.trustAll = trustAll;
    }

    @SuppressLint("CustomX509TrustManager, TrustAllX509TrustManager")
    public SSLSocketFactory getSocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] managers = new X509TrustManager[]{new X509TrustManager() {
            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        if (!trustAll && !Utils.isEmpty(certificates)) {
            try {
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(null, null);
                for (int i = 0; i < certificates.size(); i++) {
                    StringeeCertificate stringeeCertificate = certificates.get(i);
                    InputStream cerStream = stringeeCertificate.getCertificate();
                    if (cerStream != null) {
                        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                        Certificate certificate;
                        try {
                            certificate = certificateFactory.generateCertificate(cerStream);
                        } finally {
                            cerStream.close();
                        }

                        keyStore.setCertificateEntry("certificate_" + i, certificate);
                    }
                }
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(keyStore);
                managers = trustManagerFactory.getTrustManagers();
            } catch (KeyStoreException | CertificateException | IOException |
                     NoSuchAlgorithmException e) {
                Utils.reportException(SSLManager.class, e);
            }
        }
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, managers, new SecureRandom());
        return context.getSocketFactory();
    }
}
