package com.stringee.video;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LocalParticipant implements Participant {
    private String id;
    private boolean canControl;
    private boolean canPublish;
    private boolean canSubscribe;
    private final Map<String, StringeeVideoTrack> videoTrackMap = new HashMap<>();

    public LocalParticipant(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public List<StringeeVideoTrack> getVideoTracks() {
        return new ArrayList<>(videoTrackMap.values());
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean canControl() {
        return canControl;
    }

    public void setCanControl(boolean canControl) {
        this.canControl = canControl;
    }

    public boolean canPublish() {
        return canPublish;
    }

    public void setCanPublish(boolean canPublish) {
        this.canPublish = canPublish;
    }

    public boolean canSubscribe() {
        return canSubscribe;
    }

    public void setCanSubscribe(boolean canSubscribe) {
        this.canSubscribe = canSubscribe;
    }
}
