package com.stringee.video;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RemoteParticipant implements Participant {
    private String id;
    private final Map<String, StringeeVideoTrack> videoTrackMap = new HashMap<>();

    public RemoteParticipant(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<StringeeVideoTrack> getVideoTracks() {
        return new ArrayList<>(videoTrackMap.values());
    }

    public StringeeVideoTrack getVideoTrack(String id) {
        return videoTrackMap.get(id);
    }

    public void addVideoTrack(StringeeVideoTrack videoTrack) {
        videoTrackMap.put(videoTrack.getId(), videoTrack);
    }

    public void removeVideoTrack(StringeeVideoTrack videoTrack) {
        videoTrackMap.remove(videoTrack.getId());
    }
}
