package com.stringee.widget.call.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.telephony.TelephonyManager;

import com.stringee.widget.common.StringeeConstant;
import com.stringee.widget.common.StringeeNotify;
import com.stringee.widget.common.event.EventManager;

public class GSMCallStateReceiver extends BroadcastReceiver {
    public static PhoneState phoneState = PhoneState.IDLE;

    public enum PhoneState {
        IDLE("IDLE"),
        RINGING("RINGING"),
        OFFHOOK("OFFHOOK");

        private final String value;

        PhoneState(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }

        public static PhoneState getState(String value) {
            switch (value) {
                case "IDLE":
                default:
                    return IDLE;
                case "RINGING":
                    return RINGING;
                case "OFFHOOK":
                    return OFFHOOK;
            }
        }
    }

    @Override
    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if (action != null && action.equals(TelephonyManager.ACTION_PHONE_STATE_CHANGED)) {
            String state = intent.getStringExtra(TelephonyManager.EXTRA_STATE);
            if (state != null) {
                phoneState = PhoneState.getState(state);
            } else {
                phoneState = PhoneState.IDLE;
            }
            EventManager.getInstance().sendEvent(new Intent(StringeeNotify.TELEPHONY_STATE_CHANGE.getValue()).putExtra(StringeeConstant.PARAM_TELEPHONY_STATE, phoneState.getValue()));
        }
    }
}
