package com.stringee.widget.common;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class StringeeDateTimeUtils {
    private static volatile StringeeDateTimeUtils instance;

    public static synchronized StringeeDateTimeUtils getInstance() {
        if (instance == null) {
            synchronized (StringeeDateTimeUtils.class) {
                if (instance == null) {
                    instance = new StringeeDateTimeUtils();
                }
            }
        }
        return instance;
    }

    public String getCallTime(long currentTime, long startTime) {
        long time = currentTime - startTime;
        SimpleDateFormat format = new SimpleDateFormat("mm:ss", Locale.getDefault());
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format.format(new Date(time));
    }
}
