package com.stringee.widget.common;

import android.Manifest;
import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;

import androidx.annotation.RequiresApi;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;

public class StringeePermissionsUtils {
    private static volatile StringeePermissionsUtils instance;
    public static final int REQUEST_CALL_PERMISSION = 1;

    private String[] permissionVideoCall = {Manifest.permission.RECORD_AUDIO, Manifest.permission.CAMERA};
    private String[] permissionVoiceCall = {Manifest.permission.RECORD_AUDIO};

    public StringeePermissionsUtils() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
            permissionVoiceCall = new String[]{Manifest.permission.RECORD_AUDIO, Manifest.permission.BLUETOOTH_CONNECT};
            permissionVideoCall = new String[]{Manifest.permission.RECORD_AUDIO, Manifest.permission.CAMERA, Manifest.permission.BLUETOOTH_CONNECT};
        }
    }

    public static StringeePermissionsUtils getInstance() {
        if (instance == null) {
            synchronized (StringeePermissionsUtils.class) {
                if (instance == null) {
                    instance = new StringeePermissionsUtils();
                }
            }
        }
        return instance;
    }

    public boolean verifyPermissions(int[] grantResults) {
        if (grantResults.length < 1) {
            return false;
        }

        for (int result : grantResults) {
            if (result != PackageManager.PERMISSION_GRANTED) {
                return false;
            }
        }
        return true;
    }


    public boolean checkSelfPermission(Context context, String[] permissions) {
        for (String perm : permissions) {
            if (ActivityCompat.checkSelfPermission(context, perm) != PackageManager.PERMISSION_GRANTED) {
                return false;
            }
        }
        return true;
    }

    private void requestPermissions(Activity activity, String[] permissions, int requestCode) {
        ActivityCompat.requestPermissions(activity, permissions, requestCode);
    }


    @RequiresApi(api = Build.VERSION_CODES.M)
    public boolean shouldRequestPermissionRationale(Activity activity, String[] permissions) {
        boolean showSetting = false;
        for (String permission : permissions) {
            if (ContextCompat.checkSelfPermission(activity, permission) != PackageManager.PERMISSION_GRANTED
                    && !activity.shouldShowRequestPermissionRationale(permission)) {
                showSetting = true;
                break;
            }
        }
        return showSetting;
    }

    public boolean isCallPermissionGranted(Context context, boolean isVideoCall) {
        return checkSelfPermission(context, isVideoCall ? permissionVideoCall : permissionVoiceCall);
    }

    public void requestCallPermission(Activity activity, boolean isVideoCall) {
        requestPermissions(activity, isVideoCall ? permissionVideoCall : permissionVoiceCall, REQUEST_CALL_PERMISSION);
    }

    @RequiresApi(api = Build.VERSION_CODES.M)
    public boolean shouldRequestCallPermissionRationale(Activity activity, boolean isVideoCall) {
        return shouldRequestPermissionRationale(activity, isVideoCall ? permissionVideoCall : permissionVoiceCall);
    }
}
