package com.stringee.widget.common.event;

import android.content.Intent;

import com.stringee.widget.common.StringeeUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventManager implements EventSubject {

    private static volatile EventManager instance;
    private final Map<String, List<EventReceiver>> eventMap = new HashMap<>();
    private int receiverId = 0;

    public EventManager() {
    }

    public static EventManager getInstance() {
        if (instance == null) {
            synchronized (EventManager.class) {
                if (instance == null) {
                    instance = new EventManager();
                }
            }
        }
        return instance;
    }

    @Override
    public void registerEvent(EventReceiver receiver, String flag) {
        StringeeUtils.runOnUiThread(() -> {
            int id;
            synchronized (EventManager.class) {
                id = ++receiverId;
            }
            receiver.create(flag, id);
            List<EventReceiver> eventReceivers = eventMap.get(flag);
            if (StringeeUtils.isListEmpty(eventReceivers)) {
                eventReceivers = new ArrayList<>();
            }
            eventReceivers.add(receiver);
            eventMap.put(flag, eventReceivers);
        });
    }

    @Override
    public void unregisterEvent(EventReceiver receiver) {
        StringeeUtils.runOnUiThread(() -> {
            if (receiver != null) {
                List<EventReceiver> eventReceivers = eventMap.get(receiver.getFlag());
                if (!StringeeUtils.isListEmpty(eventReceivers)) {
                    for (int i = 0; i < eventReceivers.size(); i++) {
                        if (eventReceivers.get(i).getId() == receiver.getId()) {
                            eventReceivers.remove(i);
                            break;
                        }
                    }
                    eventMap.put(receiver.getFlag(), eventReceivers);
                }
            }
        });
    }

    @Override
    public void sendEvent(Intent intent) {
        StringeeUtils.runOnUiThread(() -> {
            List<EventReceiver> observers = eventMap.get(intent.getAction());
            if (!StringeeUtils.isListEmpty(observers)) {
                for (EventReceiver observer : observers) {
                    if (observer != null) {
                        observer.onReceive(intent);
                    }
                }
            }
        });
    }
}
