/*
 * Decompiled with CFR 0.152.
 */
package com.strongloop.android.loopback;

import com.google.common.collect.ImmutableMap;
import com.strongloop.android.loopback.Container;
import com.strongloop.android.loopback.RestRepository;
import com.strongloop.android.loopback.callbacks.JsonArrayParser;
import com.strongloop.android.loopback.callbacks.JsonObjectParser;
import com.strongloop.android.loopback.callbacks.ListCallback;
import com.strongloop.android.loopback.callbacks.ObjectCallback;
import com.strongloop.android.remoting.adapters.RestContract;
import com.strongloop.android.remoting.adapters.RestContractItem;
import java.util.Map;

public class ContainerRepository
extends RestRepository<Container> {
    private String getNameForRestUrl() {
        return "containers";
    }

    public ContainerRepository() {
        super("container", Container.class);
    }

    @Override
    public RestContract createContract() {
        RestContract contract = super.createContract();
        String className = this.getClassName();
        String basePath = "/" + this.getNameForRestUrl();
        contract.addItem(new RestContractItem(basePath, "POST"), className + ".create");
        contract.addItem(new RestContractItem(basePath, "GET"), className + ".getAll");
        contract.addItem(new RestContractItem(basePath + "/:name", "GET"), className + ".get");
        contract.addItem(new RestContractItem(basePath + "/:name", "DELETE"), className + ".prototype.remove");
        return contract;
    }

    public void create(String name, ObjectCallback<Container> callback) {
        this.invokeStaticMethod("create", (Map<String, Object>)ImmutableMap.of((Object)"name", (Object)name), new JsonObjectParser<Container>(this, callback));
    }

    public void get(String containerName, ObjectCallback<Container> callback) {
        this.invokeStaticMethod("get", (Map<String, Object>)ImmutableMap.of((Object)"name", (Object)containerName), new JsonObjectParser<Container>(this, callback));
    }

    public void getAll(ListCallback<Container> callback) {
        this.invokeStaticMethod("getAll", null, new JsonArrayParser<Container>(this, callback));
    }
}

