/*
 * Decompiled with CFR 0.152.
 */
package com.strongloop.android.loopback;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.strongloop.android.loopback.Container;
import com.strongloop.android.loopback.callbacks.EmptyResponseParser;
import com.strongloop.android.loopback.callbacks.VoidCallback;
import com.strongloop.android.remoting.Transient;
import com.strongloop.android.remoting.VirtualObject;
import com.strongloop.android.remoting.adapters.Adapter;
import java.io.IOException;
import java.util.Map;

public class File
extends VirtualObject {
    private String name;
    private String url;
    private Container container;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    @Transient
    public void setContainerRef(Container container) {
        this.container = container;
    }

    @Transient
    public Container getContainerRef() {
        return this.container;
    }

    public String getContainer() {
        return this.getContainerRef().getName();
    }

    public void download(final DownloadCallback callback) {
        this.invokeMethod("download", this.getCommonParams(), new Adapter.BinaryCallback(){

            @Override
            public void onSuccess(byte[] content, String contentType) {
                callback.onSuccess(content, contentType);
            }

            @Override
            public void onError(Throwable t) {
                callback.onError(t);
            }
        });
    }

    public void download(final java.io.File localFile, final VoidCallback callback) {
        this.download(new DownloadCallback(){

            @Override
            public void onSuccess(byte[] content, String contentType) {
                try {
                    Files.write((byte[])content, (java.io.File)localFile);
                    callback.onSuccess();
                }
                catch (IOException ex) {
                    callback.onError(ex);
                }
            }

            @Override
            public void onError(Throwable error) {
                callback.onError(error);
            }
        });
    }

    public void delete(VoidCallback callback) {
        this.invokeMethod("delete", this.getCommonParams(), new EmptyResponseParser(callback));
    }

    private Map<String, String> getCommonParams() {
        return ImmutableMap.of((Object)"container", (Object)this.getContainer(), (Object)"name", (Object)this.getName());
    }

    public static interface DownloadCallback {
        public void onSuccess(byte[] var1, String var2);

        public void onError(Throwable var1);
    }
}

