/*
 * Decompiled with CFR 0.152.
 */
package com.strongloop.android.loopback;

import com.google.common.collect.ImmutableMap;
import com.strongloop.android.loopback.Container;
import com.strongloop.android.loopback.File;
import com.strongloop.android.loopback.RestRepository;
import com.strongloop.android.loopback.callbacks.JsonArrayParser;
import com.strongloop.android.loopback.callbacks.JsonObjectParser;
import com.strongloop.android.loopback.callbacks.ListCallback;
import com.strongloop.android.loopback.callbacks.ObjectCallback;
import com.strongloop.android.remoting.JsonUtil;
import com.strongloop.android.remoting.adapters.Adapter;
import com.strongloop.android.remoting.adapters.RestContract;
import com.strongloop.android.remoting.adapters.RestContractItem;
import com.strongloop.android.remoting.adapters.StreamParam;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class FileRepository
extends RestRepository<File> {
    private static final String TAG = "FileRepository";
    private Container container;

    public Container getContainer() {
        return this.container;
    }

    public String getContainerName() {
        return this.getContainer().getName();
    }

    public void setContainer(Container value) {
        this.container = value;
    }

    public FileRepository() {
        super("file", File.class);
    }

    @Override
    public RestContract createContract() {
        RestContract contract = super.createContract();
        String basePath = "/containers/:container";
        String className = this.getClassName();
        contract.addItem(new RestContractItem(basePath + "/files/:name", "GET"), className + ".get");
        contract.addItem(new RestContractItem(basePath + "/files", "GET"), className + ".getAll");
        contract.addItem(RestContractItem.createMultipart(basePath + "/upload", "POST"), className + ".upload");
        contract.addItem(new RestContractItem(basePath + "/download/:name", "GET"), className + ".prototype.download");
        contract.addItem(new RestContractItem(basePath + "/files/:name", "DELETE"), className + ".prototype.delete");
        return contract;
    }

    @Override
    public File createObject(Map<String, ? extends Object> parameters) {
        File file = (File)super.createObject(parameters);
        file.setContainerRef(this.container);
        return file;
    }

    public void upload(String name, byte[] content, String contentType, ObjectCallback<File> callback) {
        this.upload(name, new ByteArrayInputStream(content), contentType, callback);
    }

    public void upload(String name, InputStream content, String contentType, ObjectCallback<File> callback) {
        StreamParam param = new StreamParam(content, name, contentType);
        this.invokeStaticMethod("upload", (Map<String, Object>)ImmutableMap.of((Object)"container", (Object)this.getContainerName(), (Object)"file", (Object)param), new UploadResponseParser(this, callback));
    }

    public void upload(java.io.File localFile, ObjectCallback<File> callback) {
        this.invokeStaticMethod("upload", (Map<String, Object>)ImmutableMap.of((Object)"container", (Object)this.getContainerName(), (Object)"file", (Object)localFile), new UploadResponseParser(this, callback));
    }

    public void get(String name, ObjectCallback<File> callback) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("container", this.getContainerName());
        params.put("name", name);
        this.invokeStaticMethod("get", params, new JsonObjectParser<File>(this, callback));
    }

    public void getAll(ListCallback<File> callback) {
        this.invokeStaticMethod("getAll", (Map<String, Object>)ImmutableMap.of((Object)"container", (Object)this.getContainerName()), new JsonArrayParser<File>(this, callback));
    }

    private class UploadResponseParser
    extends Adapter.JsonObjectCallback {
        private final FileRepository repository;
        private final ObjectCallback<File> callback;

        private UploadResponseParser(FileRepository repository, ObjectCallback<File> callback) {
            this.repository = repository;
            this.callback = callback;
        }

        @Override
        public void onSuccess(JSONObject response) {
            try {
                JSONObject data = response.getJSONObject("result").getJSONObject("files").getJSONArray("file").getJSONObject(0);
                this.callback.onSuccess((File)this.repository.createObject(JsonUtil.fromJson(data)));
            }
            catch (JSONException e) {
                this.callback.onError(e);
            }
        }

        @Override
        public void onError(Throwable t) {
            this.callback.onError(t);
        }
    }
}

