/*
 * Decompiled with CFR 0.152.
 */
package com.strongloop.android.loopback;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import com.strongloop.android.loopback.Model;
import com.strongloop.android.loopback.ModelRepository;
import com.strongloop.android.loopback.RestAdapter;
import com.strongloop.android.loopback.callbacks.VoidCallback;
import com.strongloop.android.remoting.BeanUtil;
import com.strongloop.android.remoting.Transient;
import java.util.TimeZone;
import org.apache.http.client.HttpResponseException;
import org.json.JSONArray;
import org.json.JSONException;

public class LocalInstallation {
    public static final String DEVICE_TYPE_ANDROID = "android";
    public static final String STATUS_ACTIVE = "Active";
    public static final String SHARED_PREFERENCES_NAME = LocalInstallation.class.getCanonicalName();
    private static final String PROPERTY_INSTALLATION_ID = "installationId";
    private static final String PROPERTY_DEVICE_TOKEN = "deviceToken";
    private static final String PROPERTY_APP_VERSION = "appVersion";
    private final Context applicationContext;
    private final RestAdapter loopbackAdapter;
    Object id;
    String appId;
    String appVersion;
    String userId;
    String deviceToken;
    String[] subscriptions;
    String timeZone;
    String status;

    public Object getId() {
        return this.id;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getDeviceType() {
        return DEVICE_TYPE_ANDROID;
    }

    public String getDeviceToken() {
        return this.deviceToken;
    }

    public void setDeviceToken(String deviceToken) {
        this.deviceToken = deviceToken;
        this.saveDeviceToken();
    }

    public String[] getSubscriptions() {
        return this.subscriptions;
    }

    public void setSubscriptions(String[] subscriptions) {
        this.subscriptions = subscriptions;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public LocalInstallation(Context applicationContext, RestAdapter loopbackAdapter) {
        this.applicationContext = applicationContext;
        this.loopbackAdapter = loopbackAdapter;
        this.fillDefaults();
        this.loadSharedPreferences();
    }

    public void save(final VoidCallback callback) {
        ModelRepository<Model> repository = this.loopbackAdapter.createRepository("installation");
        final Model model = repository.createModel(BeanUtil.getProperties(this, false, false));
        model.save(new VoidCallback(){

            @Override
            public void onSuccess() {
                LocalInstallation.this.id = model.getId();
                LocalInstallation.this.saveInstallationId();
                callback.onSuccess();
            }

            @Override
            public void onError(Throwable t) {
                HttpResponseException ex;
                if (t instanceof HttpResponseException && (ex = (HttpResponseException)t).getStatusCode() == 404 && LocalInstallation.this.id != null) {
                    LocalInstallation.this.id = null;
                    LocalInstallation.this.save(callback);
                    return;
                }
                callback.onError(t);
            }
        });
    }

    private void fillDefaults() {
        try {
            this.setAppVersion(this.getPackageInfo().versionName);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        this.setStatus(STATUS_ACTIVE);
        this.setTimeZone(TimeZone.getDefault().getID());
    }

    private void loadSharedPreferences() {
        int currentVersionCode;
        int savedVersionCode;
        SharedPreferences prefs = this.getSharedPreferences();
        String idJson = prefs.getString(PROPERTY_INSTALLATION_ID, null);
        if (idJson != null) {
            try {
                this.id = new JSONArray(idJson).get(0);
            }
            catch (JSONException e) {
                String msg = "Cannot parse installation id '" + idJson + "'";
                Log.e((String)"LoopBack", (String)msg, (Throwable)e);
            }
        }
        if ((savedVersionCode = prefs.getInt(PROPERTY_APP_VERSION, Integer.MIN_VALUE)) == (currentVersionCode = this.fetchAppVersionCode())) {
            this.deviceToken = prefs.getString(PROPERTY_DEVICE_TOKEN, null);
        }
    }

    private void saveInstallationId() {
        SharedPreferences.Editor editor = this.getSharedPreferences().edit();
        String json = new JSONArray().put(this.id).toString();
        editor.putString(PROPERTY_INSTALLATION_ID, json);
        editor.commit();
    }

    private void saveDeviceToken() {
        SharedPreferences.Editor editor = this.getSharedPreferences().edit();
        editor.putString(PROPERTY_DEVICE_TOKEN, this.getDeviceToken());
        editor.putInt(PROPERTY_APP_VERSION, this.fetchAppVersionCode());
        editor.commit();
    }

    private int fetchAppVersionCode() {
        try {
            return this.getPackageInfo().versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            return Integer.MIN_VALUE;
        }
    }

    @Transient
    private PackageInfo getPackageInfo() throws PackageManager.NameNotFoundException {
        return this.applicationContext.getPackageManager().getPackageInfo(this.applicationContext.getPackageName(), 0);
    }

    @Transient
    private SharedPreferences getSharedPreferences() {
        return this.applicationContext.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
    }
}

