/*
 * Decompiled with CFR 0.152.
 */
package com.strongloop.android.loopback;

import com.strongloop.android.loopback.Model;
import com.strongloop.android.loopback.RestRepository;
import com.strongloop.android.loopback.callbacks.JsonArrayParser;
import com.strongloop.android.loopback.callbacks.JsonObjectParser;
import com.strongloop.android.loopback.callbacks.ListCallback;
import com.strongloop.android.loopback.callbacks.ObjectCallback;
import com.strongloop.android.remoting.adapters.RestContract;
import com.strongloop.android.remoting.adapters.RestContractItem;
import java.util.HashMap;
import java.util.Map;
import org.atteo.evo.inflector.English;

public class ModelRepository<T extends Model>
extends RestRepository<T> {
    private String nameForRestUrl;

    public ModelRepository(String className) {
        this(className, null);
    }

    public ModelRepository(String className, Class<T> modelClass) {
        this(className, null, modelClass);
    }

    public ModelRepository(String className, String nameForRestUrl, Class<T> modelClass) {
        super(className, modelClass != null ? modelClass : Model.class);
        this.nameForRestUrl = nameForRestUrl != null ? nameForRestUrl : English.plural((String)className);
    }

    public String getNameForRestUrl() {
        return this.nameForRestUrl;
    }

    @Override
    public RestContract createContract() {
        RestContract contract = super.createContract();
        String className = this.getClassName();
        contract.addItem(new RestContractItem("/" + this.nameForRestUrl, "POST"), className + ".prototype.create");
        contract.addItem(new RestContractItem("/" + this.nameForRestUrl + "/:id", "PUT"), className + ".prototype.save");
        contract.addItem(new RestContractItem("/" + this.nameForRestUrl + "/:id", "DELETE"), className + ".prototype.remove");
        contract.addItem(new RestContractItem("/" + this.nameForRestUrl + "/:id", "GET"), className + ".findById");
        contract.addItem(new RestContractItem("/" + this.nameForRestUrl, "GET"), className + ".all");
        return contract;
    }

    public T createModel(Map<String, ? extends Object> parameters) {
        return (T)this.createObject((Map)parameters);
    }

    @Override
    public T createObject(Map<String, ? extends Object> parameters) {
        Model model = (Model)super.createObject(parameters);
        model.putAll(parameters);
        Object id = parameters.get("id");
        if (id != null) {
            model.setId(id);
        }
        return (T)model;
    }

    public void findById(Object id, ObjectCallback<T> callback) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        this.invokeStaticMethod("findById", params, new JsonObjectParser<T>(this, callback));
    }

    public void findAll(ListCallback<T> callback) {
        this.invokeStaticMethod("all", null, new JsonArrayParser<T>(this, callback));
    }

    public static interface FindAllCallback<T extends Model>
    extends ListCallback<T> {
    }

    public static interface FindCallback<T extends Model>
    extends ObjectCallback<T> {
    }
}

