/*
 * Decompiled with CFR 0.152.
 */
package com.strongloop.android.loopback;

import android.content.Context;
import android.content.SharedPreferences;
import com.strongloop.android.loopback.Model;
import com.strongloop.android.loopback.ModelRepository;
import com.strongloop.android.loopback.RestRepository;

public class RestAdapter
extends com.strongloop.android.remoting.adapters.RestAdapter {
    public static final String SHARED_PREFERENCES_NAME = RestAdapter.class.getCanonicalName();
    public static final String PROPERTY_ACCESS_TOKEN = "accessToken";
    private final Context context;

    public RestAdapter(Context context, String url) {
        super(context, url);
        if (context == null) {
            throw new NullPointerException("context must be not null");
        }
        this.context = context;
        this.setAccessToken(this.loadAccessToken());
    }

    public void setAccessToken(String accessToken) {
        this.saveAccessToken(accessToken);
        this.getClient().addHeader("Authorization", accessToken);
    }

    public void clearAccessToken() {
        this.getClient().addHeader("Authorization", null);
    }

    public Context getApplicationContext() {
        return this.context;
    }

    public ModelRepository<Model> createRepository(String name) {
        return this.createRepository(name, null, null);
    }

    public ModelRepository<Model> createRepository(String name, String nameForRestUrl) {
        return this.createRepository(name, nameForRestUrl, null);
    }

    public <T extends Model> ModelRepository<T> createRepository(String name, String nameForRestUrl, Class<T> modelClass) {
        ModelRepository<T> repository = new ModelRepository<T>(name, nameForRestUrl, modelClass);
        this.attachModelRepository(repository);
        return repository;
    }

    public <U extends RestRepository> U createRepository(Class<U> repositoryClass) {
        RestRepository repository = null;
        try {
            repository = (RestRepository)repositoryClass.newInstance();
            repository.setAdapter(this);
        }
        catch (Exception e) {
            IllegalArgumentException ex = new IllegalArgumentException();
            ex.initCause(e);
            throw ex;
        }
        this.attachModelRepository(repository);
        return (U)repository;
    }

    private void attachModelRepository(RestRepository repository) {
        this.getContract().addItemsFromContract(repository.createContract());
        repository.setAdapter(this);
    }

    private void saveAccessToken(String accessToken) {
        SharedPreferences.Editor editor = this.getSharedPreferences().edit();
        editor.putString(PROPERTY_ACCESS_TOKEN, accessToken);
        editor.commit();
    }

    private String loadAccessToken() {
        return this.getSharedPreferences().getString(PROPERTY_ACCESS_TOKEN, null);
    }

    private SharedPreferences getSharedPreferences() {
        return this.context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
    }
}

