/*
 * Decompiled with CFR 0.152.
 */
package com.strongloop.android.loopback;

import android.content.SharedPreferences;
import android.util.Log;
import com.strongloop.android.loopback.AccessToken;
import com.strongloop.android.loopback.AccessTokenRepository;
import com.strongloop.android.loopback.ModelRepository;
import com.strongloop.android.loopback.RestAdapter;
import com.strongloop.android.loopback.User;
import com.strongloop.android.loopback.callbacks.ObjectCallback;
import com.strongloop.android.loopback.callbacks.VoidCallback;
import com.strongloop.android.remoting.JsonUtil;
import com.strongloop.android.remoting.adapters.Adapter;
import com.strongloop.android.remoting.adapters.RestContract;
import com.strongloop.android.remoting.adapters.RestContractItem;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UserRepository<U extends User>
extends ModelRepository<U> {
    public static final String SHARED_PREFERENCES_NAME = RestAdapter.class.getCanonicalName();
    public static final String PROPERTY_CURRENT_USER_ID = "currentUserId";
    private AccessTokenRepository accessTokenRepository;
    private Object currentUserId;
    private boolean isCurrentUserIdLoaded;
    private U cachedCurrentUser;

    private AccessTokenRepository getAccessTokenRepository() {
        if (this.accessTokenRepository == null) {
            this.accessTokenRepository = this.getRestAdapter().createRepository(AccessTokenRepository.class);
        }
        return this.accessTokenRepository;
    }

    public UserRepository(String className, Class<U> userClass) {
        this(className, (String)null, userClass);
    }

    public UserRepository(String className, String nameForRestUrl, Class<U> userClass) {
        super(className, nameForRestUrl, userClass);
    }

    public Object getCurrentUserId() {
        this.loadCurrentUserIdIfNotLoaded();
        return this.currentUserId;
    }

    protected void setCurrentUserId(Object currentUserId) {
        this.currentUserId = currentUserId;
        this.cachedCurrentUser = null;
        this.saveCurrentUserId();
    }

    public void findCurrentUser(final ObjectCallback<U> callback) {
        if (this.getCurrentUserId() == null) {
            callback.onSuccess(null);
            return;
        }
        this.findById(this.getCurrentUserId(), new ObjectCallback<U>(){

            @Override
            public void onSuccess(U user) {
                UserRepository.this.cachedCurrentUser = user;
                callback.onSuccess(user);
            }

            @Override
            public void onError(Throwable t) {
                callback.onError(t);
            }
        });
    }

    public U getCachedCurrentUser() {
        return this.cachedCurrentUser;
    }

    public U createUser(String email, String password) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("email", email);
        map.put("password", password);
        User user = (User)this.createObject(map);
        return (U)user;
    }

    @Override
    public RestContract createContract() {
        RestContract contract = super.createContract();
        String className = this.getClassName();
        contract.addItem(new RestContractItem("/" + this.getNameForRestUrl() + "/login?include=user", "POST"), className + ".login");
        contract.addItem(new RestContractItem("/" + this.getNameForRestUrl() + "/logout", "POST"), className + ".logout");
        return contract;
    }

    public U createUser(String email, String password, Map<String, ? extends Object> parameters) {
        HashMap<String, ? extends Object> allParams = new HashMap<String, Object>();
        allParams.putAll(parameters);
        allParams.put("email", email);
        allParams.put("password", password);
        User user = (User)this.createObject(allParams);
        return (U)user;
    }

    public void loginUser(String email, String password, final LoginCallback<U> callback) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("email", email);
        params.put("password", password);
        this.invokeStaticMethod("login", params, new Adapter.JsonObjectCallback(){

            @Override
            public void onError(Throwable t) {
                callback.onError(t);
            }

            @Override
            public void onSuccess(JSONObject response) {
                AccessToken token = (AccessToken)UserRepository.this.getAccessTokenRepository().createObject(JsonUtil.fromJson(response));
                UserRepository.this.getRestAdapter().setAccessToken(token.getId().toString());
                JSONObject userJson = response.optJSONObject("user");
                User user = userJson != null ? (User)UserRepository.this.createObject(JsonUtil.fromJson(userJson)) : null;
                UserRepository.this.setCurrentUserId(token.getUserId());
                UserRepository.this.cachedCurrentUser = user;
                callback.onSuccess(token, user);
            }
        });
    }

    public void logout(final VoidCallback callback) {
        this.invokeStaticMethod("logout", null, new Adapter.Callback(){

            @Override
            public void onError(Throwable t) {
                callback.onError(t);
            }

            @Override
            public void onSuccess(String response) {
                RestAdapter radapter = UserRepository.this.getRestAdapter();
                radapter.clearAccessToken();
                UserRepository.this.setCurrentUserId(null);
                callback.onSuccess();
            }
        });
    }

    private void saveCurrentUserId() {
        SharedPreferences.Editor editor = this.getSharedPreferences().edit();
        String json = new JSONArray().put(this.getCurrentUserId()).toString();
        editor.putString(PROPERTY_CURRENT_USER_ID, json);
        editor.commit();
    }

    private void loadCurrentUserIdIfNotLoaded() {
        if (this.isCurrentUserIdLoaded) {
            return;
        }
        this.isCurrentUserIdLoaded = true;
        String json = this.getSharedPreferences().getString(PROPERTY_CURRENT_USER_ID, null);
        if (json == null) {
            return;
        }
        try {
            Object id = new JSONArray(json).get(0);
            this.setCurrentUserId(id);
        }
        catch (JSONException e) {
            String msg = "Cannot parse current user id '" + json + "'";
            Log.e((String)"LoopBack", (String)msg, (Throwable)e);
        }
    }

    private SharedPreferences getSharedPreferences() {
        return this.getApplicationContext().getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
    }

    public static interface LoginCallback<U> {
        public void onSuccess(AccessToken var1, U var2);

        public void onError(Throwable var1);
    }
}

