/*
 * Decompiled with CFR 0.152.
 */
package com.strongloop.android.remoting;

import android.util.Log;
import com.strongloop.android.remoting.Transient;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class BeanUtil {
    public static void setProperties(Object object, Map<String, ? extends Object> properties, boolean includeSuperClasses) {
        if (object == null || properties == null) {
            return;
        }
        Class<?> objectClass = object.getClass();
        for (Map.Entry<String, ? extends Object> entry : properties.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || key.length() == 0) continue;
            String setterName = "set" + Character.toUpperCase(key.charAt(0)) + key.substring(1);
            Method setter = null;
            if (value != null) {
                try {
                    setter = includeSuperClasses ? objectClass.getMethod(setterName, value.getClass()) : objectClass.getDeclaredMethod(setterName, value.getClass());
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (setter == null) {
                Method[] methods;
                for (Method method : methods = includeSuperClasses ? objectClass.getMethods() : objectClass.getDeclaredMethods()) {
                    Class<?>[] parameterTypes;
                    if (!method.getName().equals(setterName) || (parameterTypes = method.getParameterTypes()).length != 1 || !BeanUtil.isAssignableFrom(parameterTypes[0], value)) continue;
                    setter = method;
                    break;
                }
            }
            if (setter == null || setter.getAnnotation(Transient.class) != null) continue;
            try {
                setter.invoke(object, value);
            }
            catch (Exception e) {
                Log.e((String)"BeanUtil", (String)(setterName + "() failed"), (Throwable)e);
            }
        }
    }

    public static Map<String, Object> getProperties(Object object, boolean includeSuperClasses, boolean deepCopy) {
        Method[] methods;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (object == null) {
            return map;
        }
        Class<?> objectClass = object.getClass();
        for (Method method : methods = includeSuperClasses ? objectClass.getMethods() : objectClass.getDeclaredMethods()) {
            ArrayList<Object> sublist;
            if (method.getDeclaringClass() == Object.class || method.getParameterTypes().length > 0 || method.getReturnType().equals(Void.TYPE) || method.getAnnotation(Transient.class) != null) continue;
            String methodName = method.getName();
            String propertyName = "";
            if (methodName.startsWith("get")) {
                propertyName = methodName.substring(3);
            } else if (methodName.startsWith("is")) {
                propertyName = methodName.substring(2);
            }
            if (propertyName.length() <= 0 || !Character.isUpperCase(propertyName.charAt(0))) continue;
            propertyName = Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1);
            Object value = null;
            try {
                value = method.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                Log.e((String)"BeanUtil", (String)(method.getName() + "() failed"), (Throwable)e);
            }
            if (!deepCopy) {
                map.put(propertyName, value);
                continue;
            }
            if (BeanUtil.isSimpleObject(value)) {
                map.put(propertyName, value);
                continue;
            }
            if (value instanceof Map) {
                HashMap<String, Object> submap = new HashMap<String, Object>();
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    submap.put(String.valueOf(entry.getKey()), BeanUtil.convertObject(entry.getValue(), includeSuperClasses));
                }
                map.put(propertyName, submap);
                continue;
            }
            if (value instanceof Iterable) {
                sublist = new ArrayList<Object>();
                for (Object v : (Iterable)object) {
                    sublist.add(BeanUtil.convertObject(v, includeSuperClasses));
                }
                map.put(propertyName, sublist);
                continue;
            }
            if (value.getClass().isArray()) {
                sublist = new ArrayList();
                int length = Array.getLength(value);
                for (int i = 0; i < length; ++i) {
                    sublist.add(BeanUtil.convertObject(Array.get(value, i), includeSuperClasses));
                }
                map.put(propertyName, sublist);
                continue;
            }
            map.put(propertyName, BeanUtil.getProperties(value, includeSuperClasses, deepCopy));
        }
        return map;
    }

    private static boolean isAssignableFrom(Class<?> parameterType, Object value) {
        if (parameterType.isPrimitive()) {
            if (value == null) {
                return false;
            }
            Class<?> valueClass = value.getClass();
            if (parameterType == Boolean.TYPE) {
                return valueClass == Boolean.class;
            }
            if (parameterType == Byte.TYPE) {
                return valueClass == Byte.class;
            }
            if (parameterType == Character.TYPE) {
                return valueClass == Character.class;
            }
            if (parameterType == Short.TYPE) {
                return valueClass == Short.class || valueClass == Byte.class;
            }
            if (parameterType == Integer.TYPE) {
                return valueClass == Integer.class || valueClass == Character.class || valueClass == Short.class || valueClass == Byte.class;
            }
            if (parameterType == Long.TYPE) {
                return valueClass == Long.class || valueClass == Integer.class || valueClass == Character.class || valueClass == Short.class || valueClass == Byte.class;
            }
            if (parameterType == Float.TYPE) {
                return valueClass == Float.class || valueClass == Long.class || valueClass == Integer.class || valueClass == Character.class || valueClass == Short.class || valueClass == Byte.class;
            }
            if (parameterType == Double.TYPE) {
                return valueClass == Double.class || valueClass == Float.class || valueClass == Long.class || valueClass == Integer.class || valueClass == Character.class || valueClass == Short.class || valueClass == Byte.class;
            }
            return false;
        }
        return value == null || parameterType.isAssignableFrom(value.getClass());
    }

    private static boolean isSimpleObject(Object object) {
        return object == null || BeanUtil.isSimpleObjectClass(object.getClass());
    }

    private static boolean isSimpleObjectClass(Class<?> objectClass) {
        if (objectClass.isArray()) {
            return BeanUtil.isSimpleObjectClass(objectClass.getComponentType());
        }
        return objectClass.isPrimitive() || CharSequence.class.isAssignableFrom(objectClass) || Character.class.isAssignableFrom(objectClass) || Boolean.class.isAssignableFrom(objectClass) || Number.class.isAssignableFrom(objectClass);
    }

    private static Object convertObject(Object object, boolean includeSuperClasses) {
        if (BeanUtil.isSimpleObject(object)) {
            return object;
        }
        return BeanUtil.getProperties(object, includeSuperClasses, true);
    }
}

