/*
 * Decompiled with CFR 0.152.
 */
package com.strongloop.android.remoting;

import com.strongloop.android.remoting.BeanUtil;
import com.strongloop.android.remoting.VirtualObject;
import com.strongloop.android.remoting.adapters.Adapter;
import java.util.Map;

public class Repository<T extends VirtualObject> {
    private final Class<T> objectClass;
    private String className;
    private Adapter adapter;

    public Repository(String className) {
        this(className, null);
    }

    public Repository(String className, Class<T> objectClass) {
        if (className == null || className.length() == 0) {
            throw new IllegalArgumentException("Class name cannot be null or empty.");
        }
        this.className = className;
        this.objectClass = objectClass != null ? objectClass : VirtualObject.class;
    }

    public String getClassName() {
        return this.className;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public T createObject(Map<String, ? extends Object> creationParameters) {
        VirtualObject object = null;
        try {
            object = (VirtualObject)this.objectClass.newInstance();
        }
        catch (Exception e) {
            IllegalArgumentException ex = new IllegalArgumentException();
            ex.initCause(e);
            throw ex;
        }
        object.setRepository(this);
        if (creationParameters != null) {
            object.setCreationParameters(creationParameters);
            BeanUtil.setProperties(object, creationParameters, true);
        }
        return (T)object;
    }

    public void invokeStaticMethod(String method, Map<String, ? extends Object> parameters, Adapter.Callback callback) {
        if (this.adapter == null) {
            throw new IllegalArgumentException("No adapter set");
        }
        String path = this.className + "." + method;
        this.adapter.invokeStaticMethod(path, parameters, callback);
    }

    public void invokeStaticMethod(String method, Map<String, ? extends Object> parameters, Adapter.BinaryCallback callback) {
        if (this.adapter == null) {
            throw new IllegalArgumentException("No adapter set");
        }
        String path = this.className + "." + method;
        this.adapter.invokeStaticMethod(path, parameters, callback);
    }
}

