/*
 * Decompiled with CFR 0.152.
 */
package com.strongloop.android.remoting;

import com.strongloop.android.remoting.BeanUtil;
import com.strongloop.android.remoting.Repository;
import com.strongloop.android.remoting.Transient;
import com.strongloop.android.remoting.adapters.Adapter;
import java.util.Map;

public class VirtualObject {
    private Repository repository;
    private Map<String, ? extends Object> creationParameters;

    public VirtualObject() {
        this(null, null);
    }

    public VirtualObject(Repository repository, Map<String, ? extends Object> creationParameters) {
        this.setRepository(repository);
        this.setCreationParameters(creationParameters);
    }

    @Transient
    public Repository getRepository() {
        return this.repository;
    }

    @Transient
    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    @Transient
    public Map<String, ? extends Object> getCreationParameters() {
        return this.creationParameters;
    }

    @Transient
    public void setCreationParameters(Map<String, ? extends Object> creationParameters) {
        this.creationParameters = creationParameters;
    }

    public Map<String, ? extends Object> toMap() {
        return BeanUtil.getProperties(this, false, false);
    }

    public void invokeMethod(String method, Map<String, ? extends Object> parameters, Adapter.Callback callback) {
        Adapter adapter = this.repository.getAdapter();
        if (adapter == null) {
            throw new IllegalArgumentException("Repository adapter cannot be null");
        }
        String path = this.repository.getClassName() + ".prototype." + method;
        adapter.invokeInstanceMethod(path, this.creationParameters, parameters, callback);
    }

    public void invokeMethod(String method, Map<String, ? extends Object> parameters, Adapter.BinaryCallback callback) {
        Adapter adapter = this.repository.getAdapter();
        if (adapter == null) {
            throw new IllegalArgumentException("Repository adapter cannot be null");
        }
        String path = this.repository.getClassName() + ".prototype." + method;
        adapter.invokeInstanceMethod(path, this.creationParameters, parameters, callback);
    }
}

