/*
 * Decompiled with CFR 0.152.
 */
package com.strongloop.android.remoting.adapters;

import android.content.Context;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public abstract class Adapter {
    public Adapter(Context context) {
        this(context, null);
    }

    public Adapter(Context context, String url) {
        if (url != null) {
            this.connect(context, url);
        }
    }

    public abstract void connect(Context var1, String var2);

    public abstract boolean isConnected();

    public abstract void invokeStaticMethod(String var1, Map<String, ? extends Object> var2, Callback var3);

    public void invokeStaticMethod(String method, Map<String, ? extends Object> parameters, BinaryCallback callback) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support binary responses.");
    }

    public abstract void invokeInstanceMethod(String var1, Map<String, ? extends Object> var2, Map<String, ? extends Object> var3, Callback var4);

    public void invokeInstanceMethod(String method, Map<String, ? extends Object> constructorParameters, Map<String, ? extends Object> parameters, BinaryCallback callback) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support binary responses.");
    }

    public static abstract class JsonArrayCallback
    extends JsonCallback {
        public abstract void onSuccess(JSONArray var1);

        @Override
        public void onSuccess(Object response) {
            if (response instanceof JSONArray) {
                this.onSuccess((JSONArray)response);
            } else if (response == JSONObject.NULL) {
                this.onSuccess((JSONArray)null);
            } else {
                this.onError(new JSONException("Expecting a JSON array: " + response));
            }
        }
    }

    public static abstract class JsonObjectCallback
    extends JsonCallback {
        public abstract void onSuccess(JSONObject var1);

        @Override
        public void onSuccess(Object response) {
            if (response instanceof JSONObject) {
                this.onSuccess((JSONObject)response);
            } else if (response == JSONObject.NULL) {
                this.onSuccess((JSONObject)null);
            } else {
                this.onError(new JSONException("Expecting a JSON object: " + response));
            }
        }
    }

    public static abstract class JsonCallback
    implements Callback {
        public abstract void onSuccess(Object var1);

        @Override
        public void onSuccess(String response) {
            if (response == null) {
                this.onError(new JSONException("Invalid null response"));
            } else {
                try {
                    this.onSuccess(new JSONTokener(response).nextValue());
                }
                catch (JSONException e) {
                    this.onError(e);
                }
            }
        }
    }

    public static interface Callback {
        public void onSuccess(String var1);

        public void onError(Throwable var1);
    }

    public static interface BinaryCallback {
        public void onSuccess(byte[] var1, String var2);

        public void onError(Throwable var1);
    }
}

