/*
 * Decompiled with CFR 0.152.
 */
package com.strongloop.android.remoting.adapters;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.AsyncHttpResponseHandler;
import com.loopj.android.http.BinaryHttpResponseHandler;
import com.loopj.android.http.RequestParams;
import com.loopj.android.http.ResponseHandlerInterface;
import com.strongloop.android.remoting.JsonUtil;
import com.strongloop.android.remoting.adapters.Adapter;
import com.strongloop.android.remoting.adapters.RestContract;
import com.strongloop.android.remoting.adapters.StreamParam;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONException;

public class RestAdapter
extends Adapter {
    private static final String TAG = "remoting.RestAdapter";
    private RestHttpClient client;
    private RestContract contract = new RestContract();

    public RestAdapter(Context context, String url) {
        super(context, url);
    }

    public RestContract getContract() {
        return this.contract;
    }

    protected AsyncHttpClient getClient() {
        return this.client;
    }

    public void setContract(RestContract contract) {
        this.contract = contract;
    }

    @Override
    public void connect(Context context, String url) {
        if (url == null) {
            this.client = null;
        } else {
            this.client = new RestHttpClient(context, url);
            this.client.addHeader("Accept", "application/json");
        }
    }

    @Override
    public boolean isConnected() {
        return this.client != null;
    }

    @Override
    public void invokeStaticMethod(String method, Map<String, ? extends Object> parameters, Adapter.Callback callback) {
        CallbackHandler httpHandler = new CallbackHandler(callback);
        this.invokeStaticMethod(method, parameters, httpHandler);
    }

    @Override
    public void invokeStaticMethod(String method, Map<String, ? extends Object> parameters, Adapter.BinaryCallback callback) {
        BinaryHandler httpHandler = new BinaryHandler(callback);
        this.invokeStaticMethod(method, parameters, (AsyncHttpResponseHandler)httpHandler);
    }

    private void invokeStaticMethod(String method, Map<String, ? extends Object> parameters, AsyncHttpResponseHandler httpHandler) {
        if (this.contract == null) {
            throw new IllegalStateException("Invalid contract");
        }
        String verb = this.contract.getVerbForMethod(method);
        String path = this.contract.getUrlForMethod(method, parameters);
        ParameterEncoding parameterEncoding = this.contract.getParameterEncodingForMethod(method);
        this.request(path, verb, parameters, parameterEncoding, httpHandler);
    }

    @Override
    public void invokeInstanceMethod(String method, Map<String, ? extends Object> constructorParameters, Map<String, ? extends Object> parameters, Adapter.Callback callback) {
        CallbackHandler httpHandler = new CallbackHandler(callback);
        this.invokeInstanceMethod(method, constructorParameters, parameters, httpHandler);
    }

    @Override
    public void invokeInstanceMethod(String method, Map<String, ? extends Object> constructorParameters, Map<String, ? extends Object> parameters, Adapter.BinaryCallback callback) {
        BinaryHandler httpHandler = new BinaryHandler(callback);
        this.invokeInstanceMethod(method, constructorParameters, parameters, (AsyncHttpResponseHandler)httpHandler);
    }

    private void invokeInstanceMethod(String method, Map<String, ? extends Object> constructorParameters, Map<String, ? extends Object> parameters, AsyncHttpResponseHandler httpHandler) {
        if (this.contract == null) {
            throw new IllegalStateException("Invalid contract");
        }
        HashMap<String, Object> combinedParameters = new HashMap<String, Object>();
        if (constructorParameters != null) {
            combinedParameters.putAll(constructorParameters);
        }
        if (parameters != null) {
            combinedParameters.putAll(parameters);
        }
        String verb = this.contract.getVerbForMethod(method);
        String path = this.contract.getUrlForMethod(method, combinedParameters);
        ParameterEncoding parameterEncoding = this.contract.getParameterEncodingForMethod(method);
        this.request(path, verb, combinedParameters, parameterEncoding, httpHandler);
    }

    private void request(String path, String verb, Map<String, ? extends Object> parameters, ParameterEncoding parameterEncoding, AsyncHttpResponseHandler responseHandler) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Adapter not connected");
        }
        this.client.request(verb, path, parameters, parameterEncoding, responseHandler);
    }

    private static class RestHttpClient
    extends AsyncHttpClient {
        private Context context;
        private String baseUrl;

        private static String getVersionName(Context context) {
            String appVersion = null;
            try {
                PackageInfo pinfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
                appVersion = pinfo.versionName;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            return appVersion != null ? appVersion : "";
        }

        private static String getDeviceName() {
            String deviceName = Build.MODEL;
            if (!(deviceName != null && deviceName.length() != 0 || (deviceName = Build.DEVICE) != null && deviceName.length() != 0)) {
                deviceName = "Unknown";
            }
            return deviceName;
        }

        public RestHttpClient(Context context, String baseUrl) {
            String appName;
            if (baseUrl == null) {
                throw new IllegalArgumentException("The baseUrl cannot be null");
            }
            this.context = context;
            this.baseUrl = baseUrl;
            if (!this.baseUrl.endsWith("/")) {
                this.baseUrl = this.baseUrl + "/";
            }
            if (context != null) {
                String appPackageName = context.getPackageName();
                String appVersion = RestHttpClient.getVersionName(context);
                appName = appPackageName + "/" + appVersion;
            } else {
                appName = "StongLoopRemoting App";
            }
            String deviceName = RestHttpClient.getDeviceName();
            String androidVersion = Build.VERSION.RELEASE + "/API-" + Build.VERSION.SDK_INT;
            String userAgent = appName + " (" + deviceName + " Android " + androidVersion + ")";
            this.setUserAgent(userAgent);
        }

        public void request(String method, String path, Map<String, ? extends Object> parameters, ParameterEncoding parameterEncoding, AsyncHttpResponseHandler httpCallback) {
            Uri.Builder uri = Uri.parse((String)this.baseUrl).buildUpon();
            if (path != null) {
                if (path.startsWith("/")) {
                    uri.appendEncodedPath(path.substring(1));
                } else {
                    uri.appendEncodedPath(path);
                }
            }
            UrlEncodedFormEntity body = null;
            RequestParams requestParams = null;
            String charset = "utf-8";
            if (parameters != null) {
                if ("GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method) || "DELETE".equalsIgnoreCase(method)) {
                    for (Map.Entry<String, Object> entry : this.flattenParameters(parameters).entrySet()) {
                        uri.appendQueryParameter(entry.getKey(), String.valueOf(entry.getValue()));
                    }
                } else if (parameterEncoding == ParameterEncoding.FORM_URL) {
                    ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
                    for (Map.Entry<String, ? extends Object> entry : parameters.entrySet()) {
                        nameValuePairs.add(new BasicNameValuePair(entry.getKey(), String.valueOf(entry.getValue())));
                    }
                    try {
                        body = new UrlEncodedFormEntity(nameValuePairs, charset);
                        body.setContentType("application/x-www-form-urlencoded; charset=" + charset);
                    }
                    catch (UnsupportedEncodingException e) {
                        Log.e((String)RestAdapter.TAG, (String)"Couldn't encode url params", (Throwable)e);
                    }
                } else {
                    if (parameterEncoding == ParameterEncoding.FORM_MULTIPART) {
                        if (!"POST".equalsIgnoreCase(method)) {
                            throw new UnsupportedOperationException("RestAdapter does not support multipart PUT requests");
                        }
                        try {
                            requestParams = RestHttpClient.buildRequestParameters(this.flattenParameters(parameters));
                        }
                        catch (FileNotFoundException e1) {
                            throw new IllegalArgumentException("Invalid File parameter");
                        }
                    }
                    if (parameterEncoding == ParameterEncoding.JSON) {
                        String s = "";
                        try {
                            s = String.valueOf(JsonUtil.toJson(parameters));
                        }
                        catch (JSONException e) {
                            Log.e((String)RestAdapter.TAG, (String)"Couldn't convert parameters to JSON", (Throwable)e);
                        }
                        try {
                            body = new StringEntity(s, charset);
                            body.setContentType("application/json; charset=" + charset);
                        }
                        catch (UnsupportedEncodingException e) {
                            Log.e((String)RestAdapter.TAG, (String)"Couldn't encode JSON params", (Throwable)e);
                        }
                    }
                }
            }
            Header[] headers = new Header[]{new BasicHeader("Accept", "application/json")};
            String url = uri.build().toString();
            this.logRequest(method, url, (AbstractHttpEntity)body, requestParams);
            if ("GET".equalsIgnoreCase(method)) {
                this.get(this.context, url, headers, null, (ResponseHandlerInterface)httpCallback);
            } else if ("DELETE".equalsIgnoreCase(method)) {
                this.delete(this.context, url, headers, (ResponseHandlerInterface)httpCallback);
            } else if ("POST".equalsIgnoreCase(method)) {
                if (requestParams != null) {
                    this.post(this.context, url, headers, requestParams, null, (ResponseHandlerInterface)httpCallback);
                } else {
                    this.post(this.context, url, headers, (HttpEntity)body, null, (ResponseHandlerInterface)httpCallback);
                }
            } else if ("PUT".equalsIgnoreCase(method)) {
                this.put(this.context, url, headers, (HttpEntity)body, null, (ResponseHandlerInterface)httpCallback);
            } else {
                throw new IllegalArgumentException("Illegal method: " + method + ". Only GET, POST, PUT, DELETE supported.");
            }
        }

        private void logRequest(String method, String url, AbstractHttpEntity body, RequestParams requestParams) {
            if (!Log.isLoggable((String)RestAdapter.TAG, (int)3)) {
                return;
            }
            Log.d((String)RestAdapter.TAG, (String)(method + " " + url));
            if (requestParams != null) {
                Log.d((String)RestAdapter.TAG, (String)requestParams.toString());
            } else if (body != null && body.isRepeatable()) {
                try {
                    Scanner s = new Scanner(body.getContent()).useDelimiter("\\A");
                    if (s.hasNext()) {
                        Log.d((String)RestAdapter.TAG, (String)s.next());
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }

        private Map<String, Object> flattenParameters(Map<String, ? extends Object> parameters) {
            return this.flattenParameters(null, parameters);
        }

        private Map<String, Object> flattenParameters(String keyPrefix, Map<String, ? extends Object> parameters) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Map.Entry<String, ? extends Object> entry : parameters.entrySet()) {
                String key = keyPrefix != null ? keyPrefix + "[" + entry.getKey() + "]" : entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Map) {
                    result.putAll(this.flattenParameters(key, (Map)value));
                    continue;
                }
                result.put(key, value);
            }
            return result;
        }

        protected static RequestParams buildRequestParameters(Map<String, ? extends Object> parameters) throws FileNotFoundException {
            RequestParams requestParams = new RequestParams();
            for (Map.Entry<String, ? extends Object> entry : parameters.entrySet()) {
                Object value = entry.getValue();
                if (value == null) continue;
                if (value instanceof File) {
                    requestParams.put(entry.getKey(), (File)value);
                    continue;
                }
                if (value instanceof StreamParam) {
                    ((StreamParam)value).putTo(requestParams, entry.getKey());
                    continue;
                }
                if (value instanceof String) {
                    requestParams.put(entry.getKey(), (String)entry.getValue());
                    continue;
                }
                throw new IllegalArgumentException("Unknown param type for RequestParams: " + value.getClass().getName());
            }
            return requestParams;
        }
    }

    static enum ParameterEncoding {
        FORM_URL,
        JSON,
        FORM_MULTIPART;

    }

    class BinaryHandler
    extends BinaryHttpResponseHandler {
        private final Adapter.BinaryCallback callback;

        public BinaryHandler(Adapter.BinaryCallback callback) {
            super(new String[]{".*"});
            this.callback = callback;
        }

        public void onFailure(int statusCode, Header[] headers, byte[] responseBody, Throwable error) {
            if (Log.isLoggable((String)RestAdapter.TAG, (int)5)) {
                String message;
                if (error != null) {
                    message = error.toString();
                } else {
                    message = statusCode + "\n";
                    try {
                        message = message + new String(responseBody, this.getCharset());
                    }
                    catch (UnsupportedEncodingException e) {
                        message = message + new String(responseBody);
                    }
                }
                Log.w((String)RestAdapter.TAG, (String)("HTTP request (binary) failed: " + message));
            }
            this.callback.onError(error);
        }

        public void onSuccess(int statusCode, Header[] headers, byte[] binaryData) {
            if (Log.isLoggable((String)RestAdapter.TAG, (int)3)) {
                Log.d((String)RestAdapter.TAG, (String)("Success (binary): " + binaryData.length + " bytes"));
            }
            try {
                String contentType = null;
                for (Header h : headers) {
                    if (!h.getName().equalsIgnoreCase("content-type")) continue;
                    contentType = h.getValue();
                }
                this.callback.onSuccess(binaryData, contentType);
            }
            catch (Throwable t) {
                this.callback.onError(t);
            }
        }
    }

    class CallbackHandler
    extends AsyncHttpResponseHandler {
        private final Adapter.Callback callback;

        public CallbackHandler(Adapter.Callback callback) {
            this.callback = callback;
        }

        public void onSuccess(int status, Header[] headers, byte[] body) {
            try {
                String response;
                String string = response = body == null ? null : new String(body, this.getCharset());
                if (Log.isLoggable((String)RestAdapter.TAG, (int)3)) {
                    Log.d((String)RestAdapter.TAG, (String)("Success (string): " + response));
                }
                this.callback.onSuccess(response);
            }
            catch (Throwable t) {
                this.callback.onError(t);
            }
        }

        public void onFailure(int statusCode, Header[] headers, byte[] responseBody, Throwable error) {
            if (Log.isLoggable((String)RestAdapter.TAG, (int)5)) {
                String message;
                if (error != null) {
                    message = error.toString();
                } else {
                    message = statusCode + "\n";
                    try {
                        message = message + new String(responseBody, this.getCharset());
                    }
                    catch (UnsupportedEncodingException e) {
                        message = message + new String(responseBody);
                    }
                }
                Log.w((String)RestAdapter.TAG, (String)("HTTP request (string) failed: " + message));
            }
            this.callback.onError(error);
        }
    }
}

