/*
 * Decompiled with CFR 0.152.
 */
package com.strongloop.android.remoting.adapters;

import com.strongloop.android.remoting.adapters.RestAdapter;
import com.strongloop.android.remoting.adapters.RestContractItem;
import java.util.HashMap;
import java.util.Map;

public class RestContract {
    private Map<String, RestContractItem> items = new HashMap<String, RestContractItem>();

    public void addItem(RestContractItem item, String method) {
        if (item == null || method == null) {
            throw new IllegalArgumentException("Neither item nor method can be null");
        }
        this.items.put(method, item);
    }

    public void addItemsFromContract(RestContract contract) {
        if (contract == null) {
            throw new IllegalArgumentException("Contract cannot be null");
        }
        this.items.putAll(contract.items);
    }

    public String getPatternForMethod(String method) {
        if (method == null) {
            throw new IllegalArgumentException("Method cannot be null");
        }
        RestContractItem item = this.items.get(method);
        return item != null ? item.getPattern() : null;
    }

    public String getVerbForMethod(String method) {
        if (method == null) {
            throw new IllegalArgumentException("Method cannot be null");
        }
        RestContractItem item = this.items.get(method);
        return item != null ? item.getVerb() : "POST";
    }

    public RestAdapter.ParameterEncoding getParameterEncodingForMethod(String method) {
        if (method == null) {
            throw new IllegalArgumentException("Method cannot be null");
        }
        RestContractItem item = this.items.get(method);
        return item != null ? item.getParameterEncoding() : RestAdapter.ParameterEncoding.JSON;
    }

    public String getUrlForMethod(String method, Map<String, ? extends Object> parameters) {
        if (method == null) {
            throw new IllegalArgumentException("Method cannot be null");
        }
        String pattern = this.getPatternForMethod(method);
        if (pattern != null) {
            return this.getUrl(pattern, parameters);
        }
        return this.getUrlForMethodWithoutItem(method);
    }

    public String getUrlForMethodWithoutItem(String method) {
        if (method == null) {
            throw new IllegalArgumentException("Method cannot be null");
        }
        return method.replace('.', '/');
    }

    public String getUrl(String pattern, Map<String, ? extends Object> parameters) {
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern cannot be null");
        }
        String url = pattern;
        if (parameters == null) {
            return url;
        }
        for (Map.Entry<String, ? extends Object> entry : parameters.entrySet()) {
            String key = ":" + entry.getKey();
            String value = String.valueOf(entry.getValue());
            url = url.replace(key, value);
        }
        return url;
    }
}

