/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.utils.cache;

import com.syntaxphoenix.syntaxapi.utils.cache.CachedObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class CacheList<V> {
    private final List<CachedObject<V>> cacheList;
    private final long timeToLive;
    private final Consumer<ArrayList<V>> action;
    private final Thread timer;

    public CacheList(long timeToLive, long timerInterval, int maxItems) {
        this(timeToLive, timerInterval, maxItems, null);
    }

    public CacheList(long timeToLive, long timerInterval, int maxItems, Consumer<ArrayList<V>> action) {
        this.cacheList = Collections.synchronizedList(new ArrayList(maxItems));
        this.timeToLive = timeToLive * 1000L;
        this.action = action;
        this.timer = timeToLive > 0L && timerInterval > 0L ? new Thread(() -> {
            while (true) {
                try {
                    Thread.sleep(timerInterval * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.cleanup();
            }
        }) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<V> getListCopy() {
        ArrayList<V> values = new ArrayList<V>(this.size());
        List<CachedObject<V>> list = this.cacheList;
        synchronized (list) {
            Iterator<CachedObject<V>> iterator = this.cacheList.iterator();
            while (iterator.hasNext()) {
                values.add(iterator.next().getValue());
            }
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(V value) {
        List<CachedObject<V>> list = this.cacheList;
        synchronized (list) {
            this.cacheList.add(new CachedObject<V>(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(int index) {
        List<CachedObject<V>> list = this.cacheList;
        synchronized (list) {
            CachedObject<V> object = this.cacheList.get(index);
            if (object == null) {
                return null;
            }
            return object.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<V> predicateFilter(Predicate<V> predicate) {
        List<CachedObject<V>> list = this.cacheList;
        synchronized (list) {
            return this.cacheList.stream().filter(object -> predicate.test(object.getValue(false))).findFirst().map(cachedObject -> cachedObject.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<V> streamFilter(Function<Stream<V>, Optional<V>> filter) {
        List<CachedObject<V>> list = this.cacheList;
        synchronized (list) {
            Optional filtered = filter.apply(this.cacheList.stream().map(object -> object.getValue(false)));
            return !filtered.isPresent() ? filtered : this.cacheList.stream().filter(object -> object.getValue(false) == filtered.get()).findFirst().map(object -> object.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(V value) {
        List<CachedObject<V>> list = this.cacheList;
        synchronized (list) {
            return this.cacheList.stream().anyMatch(object -> object.getValue(false) == value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(Consumer<V> consume) {
        List<CachedObject<V>> list = this.cacheList;
        synchronized (list) {
            this.cacheList.stream().map(object -> object.getValue()).forEach(consume);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int index) {
        List<CachedObject<V>> list = this.cacheList;
        synchronized (list) {
            this.cacheList.remove(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(V value) {
        List<CachedObject<V>> list = this.cacheList;
        synchronized (list) {
            this.cacheList.remove(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        List<CachedObject<V>> list = this.cacheList;
        synchronized (list) {
            return this.cacheList.size();
        }
    }

    public boolean doesAutomaticCleanup() {
        return this.timer != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        long now = System.currentTimeMillis();
        ArrayList<V> delete = null;
        List<CachedObject<V>> list = this.cacheList;
        synchronized (list) {
            Iterator<CachedObject<V>> iterator = this.cacheList.iterator();
            delete = new ArrayList<V>(this.cacheList.size() / 2 + 1);
            while (iterator.hasNext()) {
                CachedObject<V> object = iterator.next();
                if (object == null || now <= this.timeToLive + object.getLastAccess()) continue;
                delete.add(object.getValue(false));
            }
        }
        if (this.action != null) {
            this.action.accept(delete);
        }
        for (Object value : delete) {
            List<CachedObject<V>> list2 = this.cacheList;
            synchronized (list2) {
                this.cacheList.remove(value);
            }
            Thread.yield();
        }
    }
}

