/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.utils.cache;

import com.syntaxphoenix.syntaxapi.utils.cache.CachedObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;

public class CacheMap<K, V> {
    private final Map<K, CachedObject<V>> cacheMap;
    private final long timeToLive;
    private final Consumer<ArrayList<CacheEntry<K, V>>> action;
    private final Thread timer;

    public CacheMap(long timeToLive, long timerInterval, int maxItems) {
        this(timeToLive, timerInterval, maxItems, null);
    }

    public CacheMap(long timeToLive, long timerInterval, int maxItems, Consumer<ArrayList<CacheEntry<K, V>>> action) {
        this.cacheMap = Collections.synchronizedMap(new HashMap(maxItems));
        this.timeToLive = timeToLive * 1000L;
        this.action = action;
        this.timer = timeToLive > 0L && timerInterval > 0L ? new Thread(() -> {
            while (true) {
                try {
                    Thread.sleep(timerInterval * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.cleanup();
            }
        }) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value) {
        Map<K, CachedObject<V>> map = this.cacheMap;
        synchronized (map) {
            this.cacheMap.put(key, new CachedObject<V>(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        Map<K, CachedObject<V>> map = this.cacheMap;
        synchronized (map) {
            CachedObject<V> object = this.cacheMap.get(key);
            if (object == null) {
                return null;
            }
            return object.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(K key) {
        Map<K, CachedObject<V>> map = this.cacheMap;
        synchronized (map) {
            this.cacheMap.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Map<K, CachedObject<V>> map = this.cacheMap;
        synchronized (map) {
            return this.cacheMap.size();
        }
    }

    public boolean doesAutomaticCleanup() {
        return this.timer != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        long now = System.currentTimeMillis();
        ArrayList<CacheEntry<K, V>> delete = null;
        Map<K, CachedObject<V>> map = this.cacheMap;
        synchronized (map) {
            Iterator<Map.Entry<K, CachedObject<V>>> iterator = this.cacheMap.entrySet().iterator();
            delete = new ArrayList<CacheEntry<K, V>>(this.cacheMap.size() / 2 + 1);
            while (iterator.hasNext()) {
                Map.Entry<K, CachedObject<V>> entry = iterator.next();
                CachedObject<V> object = entry.getValue();
                if (object == null || now <= this.timeToLive + object.getLastAccess()) continue;
                delete.add(new CacheEntry<K, V>(entry.getKey(), object.getValue(false)));
            }
        }
        if (this.action != null) {
            this.action.accept(delete);
        }
        for (CacheEntry cacheEntry : delete) {
            Map<K, CachedObject<V>> map2 = this.cacheMap;
            synchronized (map2) {
                this.cacheMap.remove(cacheEntry);
            }
            Thread.yield();
        }
    }

    protected class CacheEntry<L, B>
    implements Map.Entry<L, B> {
        private final L key;
        private final B value;

        protected CacheEntry(L key, B value) {
            this.value = value;
            this.key = key;
        }

        @Override
        public L getKey() {
            return this.key;
        }

        @Override
        public B getValue() {
            return this.value;
        }

        @Override
        public B setValue(B value) {
            return this.value;
        }
    }
}

