/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.command;

import com.syntaxphoenix.syntaxapi.command.ArgumentIdentifier;
import com.syntaxphoenix.syntaxapi.command.ArgumentType;
import com.syntaxphoenix.syntaxapi.command.BaseArgument;
import com.syntaxphoenix.syntaxapi.command.arguments.ArrayArgument;
import com.syntaxphoenix.syntaxapi.command.arguments.BigDecimalArgument;
import com.syntaxphoenix.syntaxapi.command.arguments.BigIntegerArgument;
import com.syntaxphoenix.syntaxapi.command.arguments.BooleanArgument;
import com.syntaxphoenix.syntaxapi.command.arguments.ByteArgument;
import com.syntaxphoenix.syntaxapi.command.arguments.DoubleArgument;
import com.syntaxphoenix.syntaxapi.command.arguments.FloatArgument;
import com.syntaxphoenix.syntaxapi.command.arguments.IntegerArgument;
import com.syntaxphoenix.syntaxapi.command.arguments.ListArgument;
import com.syntaxphoenix.syntaxapi.command.arguments.LongArgument;
import com.syntaxphoenix.syntaxapi.command.arguments.ShortArgument;
import com.syntaxphoenix.syntaxapi.command.arguments.StringArgument;
import com.syntaxphoenix.syntaxapi.utils.java.Strings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class DefaultArgumentIdentifier
extends ArgumentIdentifier {
    public static final Pattern LIST = Pattern.compile("\\A\\{{1}.*[,( )?]?.*\\}{1}\\z");
    public static final Pattern ARRAY = Pattern.compile("\\A\\[{1}.*[,( )?]?.*\\]{1}\\z");

    /*
     * WARNING - void declaration
     */
    @Override
    public ArrayList<BaseArgument> process(String ... arguments) {
        ArrayList<BaseArgument> list = new ArrayList<BaseArgument>();
        if (arguments == null || arguments.length == 0) {
            return list;
        }
        for (String argument : arguments) {
            Iterator iterator;
            Object entries;
            ArrayList<BaseArgument> output;
            ArgumentType type;
            ArrayList<BaseArgument> value;
            HashMap argumentMap;
            String[] args;
            if (argument.trim().isEmpty()) {
                list.add(new StringArgument(argument));
                continue;
            }
            if (Strings.isBoolean((String)argument)) {
                list.add(new BooleanArgument(Boolean.valueOf(argument)));
                continue;
            }
            if (Strings.isNumeric((String)argument)) {
                try {
                    list.add(new ByteArgument(Byte.parseByte(argument)));
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        list.add(new ShortArgument(Short.parseShort(argument)));
                    }
                    catch (NumberFormatException numberFormatException2) {
                        try {
                            list.add(new IntegerArgument(Integer.parseInt(argument)));
                        }
                        catch (NumberFormatException numberFormatException3) {
                            try {
                                list.add(new LongArgument(Long.parseLong(argument)));
                            }
                            catch (NumberFormatException numberFormatException4) {
                                try {
                                    list.add(new BigIntegerArgument(new BigInteger(argument)));
                                }
                                catch (NumberFormatException numberFormatException5) {
                                    list.add(new StringArgument(argument));
                                }
                            }
                        }
                    }
                }
                continue;
            }
            if (Strings.isDecimal((String)argument)) {
                String number = argument.split("\\.")[0];
                try {
                    Integer.parseInt(number);
                    list.add(new FloatArgument(Float.valueOf(Float.parseFloat(argument))));
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        Long.parseLong(number);
                        list.add(new DoubleArgument(Double.parseDouble(argument)));
                    }
                    catch (NumberFormatException numberFormatException6) {
                        try {
                            list.add(new BigDecimalArgument(new BigDecimal(argument)));
                        }
                        catch (NumberFormatException numberFormatException7) {
                            list.add(new StringArgument(argument));
                        }
                    }
                }
                continue;
            }
            if (LIST.matcher(argument).matches()) {
                args = argument.replaceFirst("\\A\\{", "").replaceFirst("\\}\\z", "").split(",");
                argumentMap = new HashMap();
                for (String string : args) {
                    void var12_27;
                    if (string.isEmpty()) continue;
                    if (string.startsWith(" ")) {
                        String string2 = string.replaceFirst(" ", "");
                    }
                    value = this.process(new String[]{var12_27});
                    for (BaseArgument out : value) {
                        type = out.getType();
                        if (argumentMap.containsKey((Object)type)) {
                            ((ArrayList)argumentMap.get((Object)type)).add(out);
                            continue;
                        }
                        output = new ArrayList<BaseArgument>();
                        output.add(out);
                        argumentMap.put(type, output);
                    }
                }
                entries = argumentMap.entrySet();
                iterator = entries.iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    list.add(new ListArgument((List)entry.getValue()));
                }
                continue;
            }
            if (ARRAY.matcher(argument).matches()) {
                args = argument.replaceFirst("\\A\\[", "").replaceFirst("\\]\\z", "").split(",");
                argumentMap = new HashMap();
                for (String string : args) {
                    void var12_30;
                    if (string.isEmpty()) continue;
                    if (string.startsWith(" ")) {
                        String string3 = string.replaceFirst(" ", "");
                    }
                    value = this.process(new String[]{var12_30});
                    for (BaseArgument out : value) {
                        type = out.getType();
                        if (argumentMap.containsKey((Object)type)) {
                            ((ArrayList)argumentMap.get((Object)type)).add(out);
                            continue;
                        }
                        output = new ArrayList();
                        output.add(out);
                        argumentMap.put(type, output);
                    }
                }
                entries = argumentMap.entrySet();
                iterator = entries.iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    list.add(new ArrayArgument(((ArrayList)entry.getValue()).toArray(new BaseArgument[0])));
                }
                continue;
            }
            list.add(new StringArgument(argument));
        }
        return list;
    }
}

