/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.data;

import com.syntaxphoenix.syntaxapi.data.DataAdapter;
import java.util.HashMap;
import java.util.function.Function;

public abstract class DataAdapterRegistry<B> {
    private final HashMap<Class<?>, DataAdapter<?, B, B>> adapters = new HashMap();
    private final Function<Class<?>, DataAdapter<?, B, B>> adapterCreator;

    public DataAdapterRegistry(Function<Class<?>, DataAdapter<?, B, B>> adapterCreator) {
        this.adapterCreator = adapterCreator;
    }

    protected abstract <I, R extends B> DataAdapter<I, R, B> createAdapter(Class<I> var1, Class<R> var2, Function<I, R> var3, Function<R, I> var4);

    public <T> B wrap(Class<T> type, T value) {
        DataAdapter<?, B, B> adapter = this.adapters.computeIfAbsent(type, this.adapterCreator);
        return adapter == null ? null : (B)adapter.build(value);
    }

    public <T> T extract(Class<T> type, B base) throws ClassCastException, IllegalArgumentException {
        DataAdapter<?, B, B> adapter = this.adapters.computeIfAbsent(type, this.adapterCreator);
        if (adapter == null || !adapter.isInstance(base)) {
            return null;
        }
        Object foundValue = adapter.extract(base);
        return type.isInstance(foundValue) ? (T)type.cast(foundValue) : null;
    }

    public <T> boolean isInstanceOf(Class<T> type, B base) {
        DataAdapter<?, B, B> adapter = this.adapters.computeIfAbsent(type, this.adapterCreator);
        return adapter == null ? null : Boolean.valueOf(adapter.isInstance(base));
    }

    public boolean hasAdapter(Class<?> type) {
        return this.adapters.containsKey(type);
    }
}

