/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.data;

import com.syntaxphoenix.syntaxapi.data.DataAdapterContext;
import com.syntaxphoenix.syntaxapi.data.DataType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Optional;

public class PrimitiveDataType<P, C>
implements DataType<P, C> {
    public static final PrimitiveDataType<Byte, Byte> BYTE = new PrimitiveDataType<Byte, Byte>(Byte.TYPE, Byte.class);
    public static final PrimitiveDataType<Short, Short> SHORT = new PrimitiveDataType<Short, Short>(Short.TYPE, Short.class);
    public static final PrimitiveDataType<Integer, Integer> INTEGER = new PrimitiveDataType<Integer, Integer>(Integer.TYPE, Integer.class);
    public static final PrimitiveDataType<Long, Long> LONG = new PrimitiveDataType<Long, Long>(Long.TYPE, Long.class);
    public static final PrimitiveDataType<Float, Float> FLOAT = new PrimitiveDataType<Float, Float>(Float.TYPE, Float.class);
    public static final PrimitiveDataType<Double, Double> DOUBLE = new PrimitiveDataType<Double, Double>(Double.TYPE, Double.class);
    public static final PrimitiveDataType<BigInteger, BigInteger> BIG_INTEGER = new PrimitiveDataType<BigInteger, BigInteger>(BigInteger.class, BigInteger.class);
    public static final PrimitiveDataType<BigDecimal, BigDecimal> BIG_DECIMAL = new PrimitiveDataType<BigDecimal, BigDecimal>(BigDecimal.class, BigDecimal.class);
    public static final PrimitiveDataType<Boolean, Boolean> BOOLEAN = new PrimitiveDataType<Boolean, Boolean>(Boolean.TYPE, Boolean.class);
    public static final PrimitiveDataType<String, String> STRING = new PrimitiveDataType<String, String>(String.class, String.class);
    public static final PrimitiveDataType<int[], int[]> INT_ARRAY = new PrimitiveDataType<int[], int[]>(int[].class, int[].class);
    public static final PrimitiveDataType<byte[], byte[]> BYTE_ARRAY = new PrimitiveDataType<byte[], byte[]>(byte[].class, byte[].class);
    public static final PrimitiveDataType<long[], long[]> LONG_ARRAY = new PrimitiveDataType<long[], long[]>(long[].class, long[].class);
    public static final DataType<?, ?>[] PRIMITIVES = new PrimitiveDataType[]{BYTE, SHORT, INTEGER, LONG, FLOAT, DOUBLE, BIG_INTEGER, BIG_DECIMAL, BOOLEAN, STRING, INT_ARRAY, BYTE_ARRAY, LONG_ARRAY};
    private final Class<P> primitiveType;
    private final Class<C> complexType;

    public static Optional<DataType<?, ?>> getPrimitive(Object object) {
        Class<?> clazz = object.getClass();
        return Arrays.stream(PRIMITIVES).filter(type -> type.getComplex() == clazz || type.getPrimitive() == clazz).findFirst();
    }

    private PrimitiveDataType(Class<P> primitiveType, Class<C> complexType) {
        this.primitiveType = primitiveType;
        this.complexType = complexType;
    }

    @Override
    public Class<P> getPrimitive() {
        return this.primitiveType;
    }

    @Override
    public Class<C> getComplex() {
        return this.complexType;
    }

    @Override
    public P toPrimitive(DataAdapterContext context, C complex) {
        return this.primitiveType.cast(complex);
    }

    @Override
    public C fromPrimitive(DataAdapterContext context, P primitive) {
        return this.complexType.cast(primitive);
    }
}

