/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.utils.java.lang;

import com.syntaxphoenix.syntaxapi.utils.java.lang.CharacterTools;
import com.syntaxphoenix.syntaxapi.utils.java.lang.IntegerTools;
import com.syntaxphoenix.syntaxapi.utils.java.lang.LongTools;
import com.syntaxphoenix.syntaxapi.utils.java.lang.StringTools;
import java.util.Arrays;
import sun.misc.FloatingDecimal;

abstract class AbstractStringBuilder
implements Appendable,
CharSequence {
    char[] value;
    int count;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    AbstractStringBuilder() {
    }

    AbstractStringBuilder(int var1) {
        this.value = new char[var1];
    }

    @Override
    public int length() {
        return this.count;
    }

    public int capacity() {
        return this.value.length;
    }

    public void ensureCapacity(int var1) {
        if (var1 > 0) {
            this.ensureCapacityInternal(var1);
        }
    }

    private void ensureCapacityInternal(int var1) {
        if (var1 - this.value.length > 0) {
            this.value = Arrays.copyOf(this.value, this.newCapacity(var1));
        }
    }

    private int newCapacity(int var1) {
        int var2 = (this.value.length << 1) + 2;
        if (var2 - var1 < 0) {
            var2 = var1;
        }
        return var2 > 0 && 0x7FFFFFF7 - var2 >= 0 ? var2 : this.hugeCapacity(var1);
    }

    private int hugeCapacity(int var1) {
        if (Integer.MAX_VALUE - var1 < 0) {
            throw new OutOfMemoryError();
        }
        return var1 > 0x7FFFFFF7 ? var1 : 0x7FFFFFF7;
    }

    public void trimToSize() {
        if (this.count < this.value.length) {
            this.value = Arrays.copyOf(this.value, this.count);
        }
    }

    public void setLength(int var1) {
        if (var1 < 0) {
            throw new StringIndexOutOfBoundsException(var1);
        }
        this.ensureCapacityInternal(var1);
        if (this.count < var1) {
            Arrays.fill(this.value, this.count, var1, ' ');
        }
        this.count = var1;
    }

    @Override
    public char charAt(int var1) {
        if (var1 >= 0 && var1 < this.count) {
            return this.value[var1];
        }
        throw new StringIndexOutOfBoundsException(var1);
    }

    public int codePointAt(int var1) {
        if (var1 >= 0 && var1 < this.count) {
            return CharacterTools.codePointAtImpl(this.value, var1, this.count);
        }
        throw new StringIndexOutOfBoundsException(var1);
    }

    public int codePointBefore(int var1) {
        int var2 = var1 - 1;
        if (var2 >= 0 && var2 < this.count) {
            return CharacterTools.codePointBeforeImpl(this.value, var1, 0);
        }
        throw new StringIndexOutOfBoundsException(var1);
    }

    public int codePointCount(int var1, int var2) {
        if (var1 >= 0 && var2 <= this.count && var1 <= var2) {
            return CharacterTools.codePointCountImpl(this.value, var1, var2 - var1);
        }
        throw new IndexOutOfBoundsException();
    }

    public int offsetByCodePoints(int var1, int var2) {
        if (var1 >= 0 && var1 <= this.count) {
            return CharacterTools.offsetByCodePointsImpl(this.value, 0, this.count, var1, var2);
        }
        throw new IndexOutOfBoundsException();
    }

    public void getChars(int var1, int var2, char[] var3, int var4) {
        if (var1 < 0) {
            throw new StringIndexOutOfBoundsException(var1);
        }
        if (var2 >= 0 && var2 <= this.count) {
            if (var1 > var2) {
                throw new StringIndexOutOfBoundsException("srcBegin > srcEnd");
            }
        } else {
            throw new StringIndexOutOfBoundsException(var2);
        }
        System.arraycopy(this.value, var1, var3, var4, var2 - var1);
    }

    public void setCharAt(int var1, char var2) {
        if (var1 < 0 || var1 >= this.count) {
            throw new StringIndexOutOfBoundsException(var1);
        }
        this.value[var1] = var2;
    }

    public AbstractStringBuilder append(Object var1) {
        return this.append(String.valueOf(var1));
    }

    public AbstractStringBuilder append(String var1) {
        if (var1 == null) {
            return this.appendNull();
        }
        int var2 = var1.length();
        this.ensureCapacityInternal(this.count + var2);
        var1.getChars(0, var2, this.value, this.count);
        this.count += var2;
        return this;
    }

    public AbstractStringBuilder append(StringBuffer var1) {
        if (var1 == null) {
            return this.appendNull();
        }
        int var2 = var1.length();
        this.ensureCapacityInternal(this.count + var2);
        var1.getChars(0, var2, this.value, this.count);
        this.count += var2;
        return this;
    }

    AbstractStringBuilder append(AbstractStringBuilder var1) {
        if (var1 == null) {
            return this.appendNull();
        }
        int var2 = var1.length();
        this.ensureCapacityInternal(this.count + var2);
        var1.getChars(0, var2, this.value, this.count);
        this.count += var2;
        return this;
    }

    @Override
    public AbstractStringBuilder append(CharSequence var1) {
        if (var1 == null) {
            return this.appendNull();
        }
        if (var1 instanceof String) {
            return this.append((String)var1);
        }
        return var1 instanceof AbstractStringBuilder ? this.append((AbstractStringBuilder)var1) : this.append(var1, 0, var1.length());
    }

    private AbstractStringBuilder appendNull() {
        int var1 = this.count;
        this.ensureCapacityInternal(var1 + 4);
        char[] var2 = this.value;
        var2[var1++] = 110;
        var2[var1++] = 117;
        var2[var1++] = 108;
        var2[var1++] = 108;
        this.count = var1;
        return this;
    }

    @Override
    public AbstractStringBuilder append(CharSequence var1, int var2, int var3) {
        if (var1 == null) {
            var1 = "null";
        }
        if (var2 >= 0 && var2 <= var3 && var3 <= var1.length()) {
            int var4 = var3 - var2;
            this.ensureCapacityInternal(this.count + var4);
            int var5 = var2;
            int var6 = this.count;
            while (var5 < var3) {
                this.value[var6] = var1.charAt(var5);
                ++var5;
                ++var6;
            }
            this.count += var4;
            return this;
        }
        throw new IndexOutOfBoundsException("start " + var2 + ", end " + var3 + ", s.length() " + var1.length());
    }

    public AbstractStringBuilder append(char[] var1) {
        int var2 = var1.length;
        this.ensureCapacityInternal(this.count + var2);
        System.arraycopy(var1, 0, this.value, this.count, var2);
        this.count += var2;
        return this;
    }

    public AbstractStringBuilder append(char[] var1, int var2, int var3) {
        if (var3 > 0) {
            this.ensureCapacityInternal(this.count + var3);
        }
        System.arraycopy(var1, var2, this.value, this.count, var3);
        this.count += var3;
        return this;
    }

    public AbstractStringBuilder append(boolean var1) {
        if (var1) {
            this.ensureCapacityInternal(this.count + 4);
            this.value[this.count++] = 116;
            this.value[this.count++] = 114;
            this.value[this.count++] = 117;
            this.value[this.count++] = 101;
        } else {
            this.ensureCapacityInternal(this.count + 5);
            this.value[this.count++] = 102;
            this.value[this.count++] = 97;
            this.value[this.count++] = 108;
            this.value[this.count++] = 115;
            this.value[this.count++] = 101;
        }
        return this;
    }

    @Override
    public AbstractStringBuilder append(char var1) {
        this.ensureCapacityInternal(this.count + 1);
        this.value[this.count++] = var1;
        return this;
    }

    public AbstractStringBuilder append(int var1) {
        if (var1 == Integer.MIN_VALUE) {
            this.append("-2147483648");
            return this;
        }
        int var2 = var1 < 0 ? IntegerTools.stringSize(-var1) + 1 : IntegerTools.stringSize(var1);
        int var3 = this.count + var2;
        this.ensureCapacityInternal(var3);
        IntegerTools.getChars(var1, var3, this.value);
        this.count = var3;
        return this;
    }

    public AbstractStringBuilder append(long var1) {
        if (var1 == Long.MIN_VALUE) {
            this.append("-9223372036854775808");
            return this;
        }
        int var3 = var1 < 0L ? LongTools.stringSize(-var1) + 1 : LongTools.stringSize(var1);
        int var4 = this.count + var3;
        this.ensureCapacityInternal(var4);
        LongTools.getChars(var1, var4, this.value);
        this.count = var4;
        return this;
    }

    public AbstractStringBuilder append(float var1) {
        FloatingDecimal.appendTo((float)var1, (Appendable)this);
        return this;
    }

    public AbstractStringBuilder append(double var1) {
        FloatingDecimal.appendTo((double)var1, (Appendable)this);
        return this;
    }

    public AbstractStringBuilder delete(int var1, int var2) {
        if (var1 < 0) {
            throw new StringIndexOutOfBoundsException(var1);
        }
        if (var2 > this.count) {
            var2 = this.count;
        }
        if (var1 > var2) {
            throw new StringIndexOutOfBoundsException();
        }
        int var3 = var2 - var1;
        if (var3 > 0) {
            System.arraycopy(this.value, var1 + var3, this.value, var1, this.count - var2);
            this.count -= var3;
        }
        return this;
    }

    public AbstractStringBuilder appendCodePoint(int var1) {
        int var2 = this.count;
        if (Character.isBmpCodePoint(var1)) {
            this.ensureCapacityInternal(var2 + 1);
            this.value[var2] = (char)var1;
            this.count = var2 + 1;
        } else {
            if (!Character.isValidCodePoint(var1)) {
                throw new IllegalArgumentException();
            }
            this.ensureCapacityInternal(var2 + 2);
            CharacterTools.toSurrogates(var1, this.value, var2);
            this.count = var2 + 2;
        }
        return this;
    }

    public AbstractStringBuilder deleteCharAt(int var1) {
        if (var1 >= 0 && var1 < this.count) {
            System.arraycopy(this.value, var1 + 1, this.value, var1, this.count - var1 - 1);
            --this.count;
            return this;
        }
        throw new StringIndexOutOfBoundsException(var1);
    }

    public AbstractStringBuilder replace(int var1, int var2, String var3) {
        if (var1 < 0) {
            throw new StringIndexOutOfBoundsException(var1);
        }
        if (var1 > this.count) {
            throw new StringIndexOutOfBoundsException("start > length()");
        }
        if (var1 > var2) {
            throw new StringIndexOutOfBoundsException("start > end");
        }
        if (var2 > this.count) {
            var2 = this.count;
        }
        int var4 = var3.length();
        int var5 = this.count + var4 - (var2 - var1);
        this.ensureCapacityInternal(var5);
        System.arraycopy(this.value, var2, this.value, var1 + var4, this.count - var2);
        StringTools.getChars(var3, this.value, var1);
        this.count = var5;
        return this;
    }

    public String substring(int var1) {
        return this.substring(var1, this.count);
    }

    @Override
    public CharSequence subSequence(int var1, int var2) {
        return this.substring(var1, var2);
    }

    public String substring(int var1, int var2) {
        if (var1 < 0) {
            throw new StringIndexOutOfBoundsException(var1);
        }
        if (var2 > this.count) {
            throw new StringIndexOutOfBoundsException(var2);
        }
        if (var1 > var2) {
            throw new StringIndexOutOfBoundsException(var2 - var1);
        }
        return new String(this.value, var1, var2 - var1);
    }

    public AbstractStringBuilder insert(int var1, char[] var2, int var3, int var4) {
        if (var1 >= 0 && var1 <= this.length()) {
            if (var3 >= 0 && var4 >= 0 && var3 <= var2.length - var4) {
                this.ensureCapacityInternal(this.count + var4);
                System.arraycopy(this.value, var1, this.value, var1 + var4, this.count - var1);
                System.arraycopy(var2, var3, this.value, var1, var4);
                this.count += var4;
                return this;
            }
            throw new StringIndexOutOfBoundsException("offset " + var3 + ", len " + var4 + ", str.length " + var2.length);
        }
        throw new StringIndexOutOfBoundsException(var1);
    }

    public AbstractStringBuilder insert(int var1, Object var2) {
        return this.insert(var1, String.valueOf(var2));
    }

    public AbstractStringBuilder insert(int var1, String var2) {
        if (var1 >= 0 && var1 <= this.length()) {
            if (var2 == null) {
                var2 = "null";
            }
            int var3 = var2.length();
            this.ensureCapacityInternal(this.count + var3);
            System.arraycopy(this.value, var1, this.value, var1 + var3, this.count - var1);
            StringTools.getChars(var2, this.value, var1);
            this.count += var3;
            return this;
        }
        throw new StringIndexOutOfBoundsException(var1);
    }

    public AbstractStringBuilder insert(int var1, char[] var2) {
        if (var1 >= 0 && var1 <= this.length()) {
            int var3 = var2.length;
            this.ensureCapacityInternal(this.count + var3);
            System.arraycopy(this.value, var1, this.value, var1 + var3, this.count - var1);
            System.arraycopy(var2, 0, this.value, var1, var3);
            this.count += var3;
            return this;
        }
        throw new StringIndexOutOfBoundsException(var1);
    }

    public AbstractStringBuilder insert(int var1, CharSequence var2) {
        if (var2 == null) {
            var2 = "null";
        }
        return var2 instanceof String ? this.insert(var1, (String)var2) : this.insert(var1, var2, 0, var2.length());
    }

    public AbstractStringBuilder insert(int var1, CharSequence var2, int var3, int var4) {
        if (var2 == null) {
            var2 = "null";
        }
        if (var1 >= 0 && var1 <= this.length()) {
            if (var3 >= 0 && var4 >= 0 && var3 <= var4 && var4 <= var2.length()) {
                int var5 = var4 - var3;
                this.ensureCapacityInternal(this.count + var5);
                System.arraycopy(this.value, var1, this.value, var1 + var5, this.count - var1);
                for (int var6 = var3; var6 < var4; ++var6) {
                    this.value[var1++] = var2.charAt(var6);
                }
                this.count += var5;
                return this;
            }
            throw new IndexOutOfBoundsException("start " + var3 + ", end " + var4 + ", s.length() " + var2.length());
        }
        throw new IndexOutOfBoundsException("dstOffset " + var1);
    }

    public AbstractStringBuilder insert(int var1, boolean var2) {
        return this.insert(var1, String.valueOf(var2));
    }

    public AbstractStringBuilder insert(int var1, char var2) {
        this.ensureCapacityInternal(this.count + 1);
        System.arraycopy(this.value, var1, this.value, var1 + 1, this.count - var1);
        this.value[var1] = var2;
        ++this.count;
        return this;
    }

    public AbstractStringBuilder insert(int var1, int var2) {
        return this.insert(var1, String.valueOf(var2));
    }

    public AbstractStringBuilder insert(int var1, long var2) {
        return this.insert(var1, String.valueOf(var2));
    }

    public AbstractStringBuilder insert(int var1, float var2) {
        return this.insert(var1, String.valueOf(var2));
    }

    public AbstractStringBuilder insert(int var1, double var2) {
        return this.insert(var1, String.valueOf(var2));
    }

    public int indexOf(String var1) {
        return this.indexOf(var1, 0);
    }

    public int indexOf(String var1, int var2) {
        return StringTools.indexOf(this.value, 0, this.count, var1, var2);
    }

    public int lastIndexOf(String var1) {
        return this.lastIndexOf(var1, this.count);
    }

    public int lastIndexOf(String var1, int var2) {
        return StringTools.lastIndexOf(this.value, 0, this.count, var1, var2);
    }

    public AbstractStringBuilder reverse() {
        boolean var1 = false;
        int var2 = this.count - 1;
        for (int var3 = var2 - 1 >> 1; var3 >= 0; --var3) {
            char var6;
            int var4 = var2 - var3;
            char var5 = this.value[var3];
            this.value[var3] = var6 = this.value[var4];
            this.value[var4] = var5;
            if (!Character.isSurrogate(var5) && !Character.isSurrogate(var6)) continue;
            var1 = true;
        }
        if (var1) {
            this.reverseAllValidSurrogatePairs();
        }
        return this;
    }

    private void reverseAllValidSurrogatePairs() {
        for (int var1 = 0; var1 < this.count - 1; ++var1) {
            char var3;
            char var2 = this.value[var1];
            if (!Character.isLowSurrogate(var2) || !Character.isHighSurrogate(var3 = this.value[var1 + 1])) continue;
            this.value[var1++] = var3;
            this.value[var1] = var2;
        }
    }

    @Override
    public abstract String toString();

    final char[] getValue() {
        return this.value;
    }
}

