/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.utils.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public final class Collect {
    public static final Set<Collector.Characteristics> CH_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH));

    public static <I, R> Function<I, R> castingIdentity() {
        return i -> i;
    }

    public static <T> Function<T, T> passthrough() {
        return i -> i;
    }

    public static <T, C extends Collection<T>> Collector<C, ?, C> combineCollection(Supplier<C> collectionFactory) {
        return new CollectorImpl<Collection, Collection, T>(collectionFactory, Collection::addAll, (r1, r2) -> {
            r1.addAll(r2);
            return r1;
        }, Collect.passthrough(), CH_ID);
    }

    public static <T> Collector<List<T>, ?, List<T>> combineList() {
        return new CollectorImpl<List, List, T>(ArrayList::new, List::addAll, (left, right) -> {
            left.addAll(right);
            return left;
        }, Collect.passthrough(), CH_ID);
    }

    public static <T, A> Collector<T, List<A>, List<A>> collectList(BiConsumer<List<A>, T> consumer) {
        return new CollectorImpl<T, List<A>, T>(ArrayList::new, consumer, (left, right) -> {
            left.addAll(right);
            return left;
        }, Collect.passthrough(), CH_ID);
    }

    public static class CollectorImpl<T, A, R>
    implements Collector<T, A, R> {
        private final Supplier<A> supplier;
        private final BiConsumer<A, T> accumulator;
        private final BinaryOperator<A> combiner;
        private final Function<A, R> finisher;
        private final Set<Collector.Characteristics> characteristics;

        public CollectorImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Function<A, R> finisher, Set<Collector.Characteristics> characteristics) {
            this.supplier = supplier;
            this.accumulator = accumulator;
            this.combiner = combiner;
            this.finisher = finisher;
            this.characteristics = characteristics;
        }

        public CollectorImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Set<Collector.Characteristics> characteristics) {
            this(supplier, accumulator, combiner, Collect.castingIdentity(), characteristics);
        }

        @Override
        public BiConsumer<A, T> accumulator() {
            return this.accumulator;
        }

        @Override
        public Supplier<A> supplier() {
            return this.supplier;
        }

        @Override
        public BinaryOperator<A> combiner() {
            return this.combiner;
        }

        @Override
        public Function<A, R> finisher() {
            return this.finisher;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return this.characteristics;
        }
    }
}

