/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.thread;

import com.syntaxphoenix.syntaxapi.thread.SynReportThrower;
import com.syntaxphoenix.syntaxapi.thread.SynThreadReporter;
import java.util.concurrent.ThreadFactory;

public class SynThreadFactory
implements ThreadFactory,
SynReportThrower {
    private final SynThreadReporter reporter;
    private final String poolName;
    private int count = 0;

    public SynThreadFactory(String poolName) {
        this.poolName = poolName;
        this.reporter = null;
    }

    public SynThreadFactory(String poolName, SynThreadReporter reporter) {
        this.poolName = poolName;
        this.reporter = reporter;
    }

    public final String getName() {
        return this.poolName;
    }

    public final SynThreadReporter getReporter() {
        return this.reporter;
    }

    public int getCreatedThreadCount() {
        return this.count;
    }

    private final String nextName() {
        String name = this.poolName + " - " + this.count;
        ++this.count;
        return name;
    }

    @Override
    public Thread newThread(Runnable command) {
        Thread thread = this.reporter != null ? new Thread(() -> {
            try {
                command.run();
            }
            catch (Throwable throwable) {
                this.reporter.catchFail(throwable, this, Thread.currentThread(), command);
            }
        }) : new Thread(command);
        thread.setName(this.nextName());
        return thread;
    }

    @Override
    public final boolean isPool() {
        return false;
    }
}

