/*
 * Decompiled with CFR 0.152.
 */
package com.testmonitor.actions;

import com.testmonitor.api.Connector;
import com.testmonitor.parsers.TestCaseFolderParser;
import com.testmonitor.resources.Project;
import com.testmonitor.resources.TestCaseFolder;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.json.JSONObject;

public class TestCaseFolders {
    private final Connector connector;
    private final Integer projectId;

    public TestCaseFolders(Connector connector, Project project) {
        this.connector = connector;
        this.projectId = project.getId();
    }

    public ArrayList<TestCaseFolder> list() throws IOException, URISyntaxException {
        return this.list(1);
    }

    public ArrayList<TestCaseFolder> list(Integer page) throws IOException, URISyntaxException {
        return this.list(0, page, 15);
    }

    public ArrayList<TestCaseFolder> list(Integer page, Integer limit) throws IOException, URISyntaxException {
        return this.list(0, page, limit);
    }

    public ArrayList<TestCaseFolder> list(Integer parentId, Integer page, Integer limit) throws IOException, URISyntaxException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("project_id", this.projectId.toString()));
        params.add((NameValuePair)new BasicNameValuePair("parent_id", parentId.toString()));
        params.add((NameValuePair)new BasicNameValuePair("page", page.toString()));
        params.add((NameValuePair)new BasicNameValuePair("limit", limit.toString()));
        return TestCaseFolderParser.parse(this.connector.get("test-case/folders", params));
    }

    public TestCaseFolder get(Integer id) throws IOException, URISyntaxException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("project_id", this.projectId.toString()));
        JSONObject response = this.connector.get("test-case/folders/" + id, params);
        HashMap testCaseFolder = (HashMap)response.getJSONObject("data").toMap();
        return TestCaseFolderParser.parse(testCaseFolder);
    }

    public TestCaseFolder create(TestCaseFolder testCaseFolder) throws IOException {
        testCaseFolder.setProjectId(this.projectId);
        JSONObject response = this.connector.post("test-case/folders", testCaseFolder.toHttpParams());
        testCaseFolder.setId(response.getJSONObject("data").get("id").toString());
        return testCaseFolder;
    }

    public TestCaseFolder create(String name) throws IOException {
        TestCaseFolder testCaseFolder = new TestCaseFolder();
        testCaseFolder.setName(name);
        return this.create(testCaseFolder);
    }

    public TestCaseFolder create(String name, TestCaseFolder parent) throws IOException {
        TestCaseFolder testCaseFolder = new TestCaseFolder();
        testCaseFolder.setName(name);
        testCaseFolder.setParent(parent);
        return this.create(testCaseFolder);
    }

    public TestCaseFolder createSubfolder(String name, TestCaseFolder parent) throws IOException {
        TestCaseFolder testCaseFolder = new TestCaseFolder();
        testCaseFolder.setName(name).setProjectId(parent.getProjectId()).setParentId(parent.getId());
        return this.create(testCaseFolder);
    }

    public TestCaseFolder createSubfolder(TestCaseFolder child, TestCaseFolder parent) throws IOException {
        return this.create(child.setParent(parent));
    }

    public TestCaseFolder clone(TestCaseFolder source, String name, boolean includeSubfolders, boolean includeTestCases) throws IOException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("name", name));
        params.add((NameValuePair)new BasicNameValuePair("include_subfolders", includeSubfolders ? "1" : "0"));
        params.add((NameValuePair)new BasicNameValuePair("include_test_cases", includeTestCases ? "1" : "0"));
        JSONObject response = this.connector.post("test-case/folder/" + source.getId().toString() + "/clone", params);
        HashMap testCaseFolder = (HashMap)response.getJSONObject("data").toMap();
        return TestCaseFolderParser.parse(testCaseFolder);
    }

    public TestCaseFolder clone(TestCaseFolder source) throws IOException {
        return this.clone(source, source.getName() + " (Copy)", true, true);
    }

    public TestCaseFolder clone(TestCaseFolder source, String name) throws IOException {
        return this.clone(source, name, true, true);
    }

    public TestCaseFolder findOrCreate(String name) throws IOException, URISyntaxException {
        ArrayList<TestCaseFolder> testCaseFolders = this.findByName(name);
        if (testCaseFolders.size() > 0) {
            return testCaseFolders.get(0);
        }
        return this.create(name);
    }

    public TestCaseFolder findOrCreate(String name, TestCaseFolder parent) throws IOException, URISyntaxException {
        ArrayList<TestCaseFolder> testCaseFolders = this.findByName(name, parent);
        if (testCaseFolders.size() > 0) {
            return testCaseFolders.get(0);
        }
        return this.create(name, parent);
    }

    public ArrayList<TestCaseFolder> findByName(String name) throws IOException, URISyntaxException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("project_id", this.projectId.toString()));
        params.add((NameValuePair)new BasicNameValuePair("filter[name]", name));
        return TestCaseFolderParser.parse(this.connector.get("test-case/folders", params));
    }

    public ArrayList<TestCaseFolder> findByName(String name, Integer parentId) throws IOException, URISyntaxException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("project_id", this.projectId.toString()));
        params.add((NameValuePair)new BasicNameValuePair("parent_id", parentId.toString()));
        params.add((NameValuePair)new BasicNameValuePair("filter[name]", name));
        return TestCaseFolderParser.parse(this.connector.get("test-case/folders", params));
    }

    public ArrayList<TestCaseFolder> findByName(String name, TestCaseFolder parent) throws IOException, URISyntaxException {
        return this.findByName(name, parent.getId());
    }

    public TestCaseFolder update(TestCaseFolder testCaseFolder) throws IOException {
        JSONObject response = this.connector.put("test-case/folders/" + testCaseFolder.getId(), testCaseFolder.toHttpParams());
        HashMap updatedTestCaseFolder = (HashMap)response.getJSONObject("data").toMap();
        return TestCaseFolderParser.parse(updatedTestCaseFolder);
    }
}

