/*
 * Decompiled with CFR 0.152.
 */
package com.textkernel.tx;

import com.textkernel.tx.TxClient;
import com.textkernel.tx.exceptions.TxException;
import com.textkernel.tx.models.api.bimetricscoring.BimetricScoreJobRequest;
import com.textkernel.tx.models.api.bimetricscoring.BimetricScoreResumeRequest;
import com.textkernel.tx.models.api.bimetricscoring.IParsedDocWithId;
import com.textkernel.tx.models.api.bimetricscoring.ParsedJobWithId;
import com.textkernel.tx.models.api.bimetricscoring.ParsedResumeWithId;
import com.textkernel.tx.models.api.matching.CategoryWeights;
import com.textkernel.tx.models.api.matching.MatchJobRequest;
import com.textkernel.tx.models.api.matching.MatchResumeRequest;
import com.textkernel.tx.models.api.matching.SearchRequest;
import com.textkernel.tx.models.api.matching.request.FilterCriteria;
import com.textkernel.tx.models.api.matching.request.MatchByDocumentIdOptions;
import com.textkernel.tx.models.api.matching.request.PaginationSettings;
import com.textkernel.tx.models.api.matching.request.SearchMatchSettings;
import com.textkernel.tx.models.api.matching.ui.GenerateUIResponse;
import com.textkernel.tx.models.api.matching.ui.request.MatchUISettings;
import com.textkernel.tx.models.api.matching.ui.request.UIBimetricScoreJobRequest;
import com.textkernel.tx.models.api.matching.ui.request.UIBimetricScoreResumeRequest;
import com.textkernel.tx.models.api.matching.ui.request.UIMatchByDocumentIdOptions;
import com.textkernel.tx.models.api.matching.ui.request.UIMatchJobRequest;
import com.textkernel.tx.models.api.matching.ui.request.UIMatchResumeRequest;
import com.textkernel.tx.models.api.matching.ui.request.UISearchRequest;
import com.textkernel.tx.models.job.ParsedJob;
import com.textkernel.tx.models.resume.ParsedResume;
import java.util.List;

public class TxUIClient {
    private final MatchUISettings _uiSessionOptions;
    private final TxClient _client;

    TxUIClient(MatchUISettings uiOptions, TxClient client) {
        this._uiSessionOptions = uiOptions;
        this._client = client;
    }

    public GenerateUIResponse match(ParsedResume resume, List<String> indexesToQuery, CategoryWeights preferredWeights, FilterCriteria filters, SearchMatchSettings settings, int numResults) throws TxException {
        MatchResumeRequest request = this._client.createRequest(resume, indexesToQuery, preferredWeights, filters, settings, numResults);
        UIMatchResumeRequest uiRequest = new UIMatchResumeRequest(request, this._uiSessionOptions);
        return this._client.uiMatch(uiRequest);
    }

    public GenerateUIResponse match(ParsedJob job, List<String> indexesToQuery, CategoryWeights preferredWeights, FilterCriteria filters, SearchMatchSettings settings, int numResults) throws TxException {
        MatchJobRequest request = this._client.createRequest(job, indexesToQuery, preferredWeights, filters, settings, numResults);
        UIMatchJobRequest uiRequest = new UIMatchJobRequest(request, this._uiSessionOptions);
        return this._client.uiMatch(uiRequest);
    }

    public GenerateUIResponse match(String indexId, String documentId, List<String> indexesToQuery, CategoryWeights preferredWeights, FilterCriteria filters, SearchMatchSettings settings, int numResults) throws TxException {
        MatchByDocumentIdOptions request = this._client.createRequest(indexesToQuery, preferredWeights, filters, settings, numResults);
        UIMatchByDocumentIdOptions uiRequest = new UIMatchByDocumentIdOptions(request, this._uiSessionOptions);
        return this._client.uiMatch(indexId, documentId, uiRequest);
    }

    public GenerateUIResponse search(List<String> indexesToQuery, FilterCriteria query, SearchMatchSettings settings, PaginationSettings pagination) throws TxException {
        SearchRequest request = this._client.createRequest(indexesToQuery, query, settings, pagination);
        UISearchRequest uiRequest = new UISearchRequest(request, this._uiSessionOptions);
        return this._client.uiSearch(uiRequest);
    }

    public <TTarget extends IParsedDocWithId> GenerateUIResponse bimetricScore(ParsedResumeWithId sourceResume, List<TTarget> targetDocuments, CategoryWeights preferredWeights, SearchMatchSettings settings) throws TxException {
        BimetricScoreResumeRequest request = this._client.createRequest(sourceResume, targetDocuments, preferredWeights, settings);
        UIBimetricScoreResumeRequest uiRequest = new UIBimetricScoreResumeRequest(request, this._uiSessionOptions);
        return this._client.uiBimetricScore(uiRequest);
    }

    public <TTarget extends IParsedDocWithId> GenerateUIResponse bimetricScore(ParsedJobWithId sourceJob, List<TTarget> targetDocuments, CategoryWeights preferredWeights, SearchMatchSettings settings) throws TxException {
        BimetricScoreJobRequest request = this._client.createRequest(sourceJob, targetDocuments, preferredWeights, settings);
        UIBimetricScoreJobRequest uiRequest = new UIBimetricScoreJobRequest(request, this._uiSessionOptions);
        return this._client.uiBimetricScore(uiRequest);
    }
}

