/*
 * Decompiled with CFR 0.152.
 */
package com.textkernel.tx.models;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Base64;

public class Document {
    protected String _asBase64;
    public LocalDate LastModified;

    public String getAsBase64() {
        return this._asBase64;
    }

    public Document(byte[] fileBytes, LocalDate lastModified) {
        if (fileBytes == null || fileBytes.length == 0) {
            throw new IllegalArgumentException("'fileBytes' cannot be null");
        }
        this._asBase64 = Base64.getEncoder().encodeToString(fileBytes);
        this.LastModified = lastModified;
        if (this.LastModified == LocalDate.MIN || this.LastModified == LocalDate.MAX) {
            throw new IllegalArgumentException("You must provide a valid last-modified date so that parser metadata is accurate");
        }
    }

    public Document(String path) throws IOException {
        this(Files.readAllBytes(Paths.get(path, new String[0])), Files.getLastModifiedTime(Paths.get(path, new String[0]), new LinkOption[0]).toInstant().atZone(ZoneId.systemDefault()));
    }

    private Document(byte[] fileBytes, ZonedDateTime time) {
        this(fileBytes, LocalDate.of(time.getYear(), time.getMonth(), time.getDayOfMonth()));
    }
}

