// Copyright © 2023 Textkernel BV. All rights reserved.
// This file is provided for use by, or on behalf of, Textkernel licensees
// within the terms of their license of Textkernel products or Textkernel customers
// within the Terms of Service pertaining to the Textkernel SaaS products.

package com.textkernel.tx.models.api.matchV2.querying;

import java.util.List;

import com.textkernel.tx.models.api.matchV2.querying.results.QueryPart;
import com.textkernel.tx.models.api.matchV2.querying.results.SearchResult;

/** A search query */
public class SearchQuery {
    /**
     * User typed keyword query (see query language description). It may be joined
     * with the {@link #QueryParts} if it is a single OR-combination part that can be joined.
     */
    public String QueryString;

    /** Generated by a previous query. See {@link SearchResult#QueryParts} */
    public List<QueryPart> QueryParts;
}
