/*
 * Decompiled with CFR 0.152.
 */
package com.textkernel.tx;

import com.textkernel.tx.TxClientSettings;
import com.textkernel.tx.services.AccountService;
import com.textkernel.tx.services.FormatterService;
import com.textkernel.tx.services.GeocoderService;
import com.textkernel.tx.services.MatchV2Service;
import com.textkernel.tx.services.ParserService;
import com.textkernel.tx.services.SearchMatchService;
import com.textkernel.tx.services.SkillsIntelligenceService;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class TxClient {
    private static final String _sdkVersion = TxClient.class.getPackage().getImplementationVersion();
    private AccountService _accountService;
    private FormatterService _formatterService;
    private GeocoderService _geocoderService;
    private MatchV2Service _searchMatchV2Service;
    private ParserService _parserService;
    private SearchMatchService _searchMatchV1Service;
    private SkillsIntelligenceService _skillsIntelligenceService;
    public static boolean ShowFullRequestBodyInExceptions = false;

    public AccountService account() {
        return this._accountService;
    }

    public FormatterService formatter() {
        return this._formatterService;
    }

    public GeocoderService geocoder() {
        return this._geocoderService;
    }

    public MatchV2Service searchMatchV2() {
        return this._searchMatchV2Service;
    }

    public ParserService parser() {
        return this._parserService;
    }

    public SkillsIntelligenceService skillsIntelligence() {
        return this._skillsIntelligenceService;
    }

    public SearchMatchService searchMatchV1() {
        return this._searchMatchV1Service;
    }

    public TxClient(TxClientSettings settings) {
        this(settings, 30L);
    }

    public TxClient(final TxClientSettings settings, long httpTimeoutSecs) {
        String trackingTagsHeaderValue;
        if (settings == null) {
            throw new IllegalArgumentException("'settings' cannot be null");
        }
        if (settings.AccountId == null || settings.AccountId.length() == 0) {
            throw new IllegalArgumentException("'accountId' must have a valid value");
        }
        if (settings.ServiceKey == null || settings.ServiceKey.length() == 0) {
            throw new IllegalArgumentException("'serviceKey' must have a valid value");
        }
        if (settings.DataCenter == null) {
            throw new IllegalArgumentException("'dataCenter' must not be null");
        }
        if (httpTimeoutSecs <= 0L) {
            throw new IllegalArgumentException("'httpTimeoutSecs' must be greater than 0");
        }
        if (settings.TrackingTags != null && settings.TrackingTags.size() > 0) {
            trackingTagsHeaderValue = String.join((CharSequence)", ", settings.TrackingTags);
            if (trackingTagsHeaderValue.length() >= 75) {
                throw new IllegalArgumentException("'trackingTags' has too many values or the values are too long");
            }
        } else {
            trackingTagsHeaderValue = null;
        }
        OkHttpClient httpClient = new OkHttpClient.Builder().addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request original = chain.request();
                Request.Builder builder = original.newBuilder();
                builder.header("Tx-AccountId", settings.AccountId);
                builder.header("Tx-ServiceKey", settings.ServiceKey);
                builder.header("User-Agent", "tx-java-" + _sdkVersion);
                if (trackingTagsHeaderValue != null && !trackingTagsHeaderValue.isEmpty()) {
                    builder.header("Tx-TrackingTag", trackingTagsHeaderValue);
                }
                Request request = builder.build();
                return chain.proceed(request);
            }
        }).connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(httpTimeoutSecs, TimeUnit.SECONDS).build();
        this._accountService = new AccountService(httpClient, settings);
        this._formatterService = new FormatterService(httpClient, settings);
        this._geocoderService = new GeocoderService(httpClient, settings);
        this._parserService = new ParserService(httpClient, settings);
        this._searchMatchV1Service = new SearchMatchService(httpClient, settings);
        this._searchMatchV2Service = new MatchV2Service(httpClient, settings);
        this._skillsIntelligenceService = new SkillsIntelligenceService(httpClient, settings);
    }
}

