/*
 * Decompiled with CFR 0.152.
 */
package com.textkernel.tx.services;

import com.textkernel.tx.DataCenter;
import com.textkernel.tx.models.api.dataenrichment.TaxonomyFormat;
import java.util.List;

public class ApiEndpoints {
    private DataCenter _dataCenter;

    ApiEndpoints(DataCenter dataCenter) {
        if (dataCenter == null) {
            throw new IllegalArgumentException("dataCenter cannot be null");
        }
        this._dataCenter = dataCenter;
    }

    private static String sanitize(String indexOrDocId) throws IllegalArgumentException {
        if (indexOrDocId == null || indexOrDocId.length() == 0) {
            throw new IllegalArgumentException("Index or document id is null or empty");
        }
        for (char c : indexOrDocId.toCharArray()) {
            if (Character.isLetterOrDigit(c) || c == '-' || c == '_') continue;
            String charName = Character.isWhitespace(c) ? "whitespace" : String.valueOf(c);
            throw new IllegalArgumentException("Index or document id contains an invalid character: " + charName);
        }
        return indexOrDocId;
    }

    String account() {
        return this._dataCenter.Url + "/account";
    }

    String parseResume() {
        return this._dataCenter.Url + "/parser/resume";
    }

    String parseJob() {
        return this._dataCenter.Url + "/parser/joborder";
    }

    String index(String id) {
        return this._dataCenter.Url + "/index/" + ApiEndpoints.sanitize(id);
    }

    String indexDocumentCount(String id) {
        return this._dataCenter.Url + "/index/" + ApiEndpoints.sanitize(id) + "/count";
    }

    String allIndexes() {
        return this._dataCenter.Url + "/index";
    }

    String resume(String indexId, String docId) {
        return this._dataCenter.Url + "/index/" + ApiEndpoints.sanitize(indexId) + "/resume/" + ApiEndpoints.sanitize(docId);
    }

    String job(String indexId, String docId) {
        return this._dataCenter.Url + "/index/" + ApiEndpoints.sanitize(indexId) + "/joborder/" + ApiEndpoints.sanitize(docId);
    }

    String multipleResumes(String indexId) {
        return this._dataCenter.Url + "/index/" + ApiEndpoints.sanitize(indexId) + "/resumes";
    }

    String multipleJobs(String indexId) {
        return this._dataCenter.Url + "/index/" + ApiEndpoints.sanitize(indexId) + "/joborders";
    }

    String document(String indexId, String docId) {
        return this._dataCenter.Url + "/index/" + ApiEndpoints.sanitize(indexId) + "/documents/" + ApiEndpoints.sanitize(docId);
    }

    String multipleDocuments(String indexId) {
        return this._dataCenter.Url + "/index/" + ApiEndpoints.sanitize(indexId) + "/documents";
    }

    String matchResume() {
        return this._dataCenter.Url + "/matcher/resume";
    }

    String matchJob() {
        return this._dataCenter.Url + "/matcher/joborder";
    }

    String matchDocId(String indexId, String docId) {
        return this._dataCenter.Url + "/matcher/indexes/" + ApiEndpoints.sanitize(indexId) + "/documents/" + ApiEndpoints.sanitize(docId);
    }

    String search() {
        return this._dataCenter.Url + "/searcher";
    }

    String bimetricScoreResume() {
        return this._dataCenter.Url + "/scorer/bimetric/resume";
    }

    String bimetricScoreJob() {
        return this._dataCenter.Url + "/scorer/bimetric/joborder";
    }

    String geocodeResume() {
        return this._dataCenter.Url + "/geocoder/resume";
    }

    String geocodeJob() {
        return this._dataCenter.Url + "/geocoder/joborder";
    }

    String geocodeAndIndexResume() {
        return this._dataCenter.Url + "/geocodeAndIndex/resume";
    }

    String geocodeAndIndexJob() {
        return this._dataCenter.Url + "/geocodeAndIndex/joborder";
    }

    static String DESVersion(boolean includeCerts) {
        return includeCerts ? "/v2" : "";
    }

    String desSkillsGetTaxonomy(TaxonomyFormat format, boolean includeCerts) {
        return this._dataCenter.Url + "/skills" + ApiEndpoints.DESVersion(includeCerts) + "/taxonomy?format=" + (Object)((Object)format);
    }

    String desSkillsGetMetadata(boolean includeCerts) {
        return this._dataCenter.Url + "/skills" + ApiEndpoints.DESVersion(includeCerts) + "/metadata";
    }

    String desSkillsNormalize(boolean includeCerts) {
        return this._dataCenter.Url + "/skills" + ApiEndpoints.DESVersion(includeCerts) + "/normalize";
    }

    String desSkillsExtract(boolean includeCerts) {
        return this._dataCenter.Url + "/skills" + ApiEndpoints.DESVersion(includeCerts) + "/extract";
    }

    String desSkillsLookup(boolean includeCerts) {
        return this._dataCenter.Url + "/skills" + ApiEndpoints.DESVersion(includeCerts) + "/lookup";
    }

    String desSkillsAutoComplete(boolean includeCerts) {
        return this._dataCenter.Url + "/skills" + ApiEndpoints.DESVersion(includeCerts) + "/autoComplete";
    }

    String desProfessionsGetTaxonomy(TaxonomyFormat format, String language) {
        return this._dataCenter.Url + "/professions/taxonomy?format=" + (Object)((Object)format) + "&language=" + language;
    }

    String desProfessionsGetMetadata() {
        return this._dataCenter.Url + "/professions/metadata";
    }

    String desProfessionsNormalize() {
        return this._dataCenter.Url + "/professions/normalize";
    }

    String desProfessionsLookup() {
        return this._dataCenter.Url + "/professions/lookup";
    }

    String desProfessionsAutoComplete() {
        return this._dataCenter.Url + "/professions/autoComplete";
    }

    String desOntologySuggestSkillsFromProfessions(boolean includeCerts) {
        return this._dataCenter.Url + "/ontology" + ApiEndpoints.DESVersion(includeCerts) + "/suggest-skills-from-professions";
    }

    String desOntologySuggestSkillsFromSkills(boolean includeCerts) {
        return this._dataCenter.Url + "/ontology" + ApiEndpoints.DESVersion(includeCerts) + "/suggest-skills-from-skills";
    }

    String desOntologyCompareProfessions(boolean includeCerts) {
        return this._dataCenter.Url + "/ontology" + ApiEndpoints.DESVersion(includeCerts) + "/compare-professions";
    }

    String desOntologySuggestProfessions(boolean includeCerts) {
        return this._dataCenter.Url + "/ontology" + ApiEndpoints.DESVersion(includeCerts) + "/suggest-professions";
    }

    String desOntologyCompareSkillsToProfession(boolean includeCerts) {
        return this._dataCenter.Url + "/ontology" + ApiEndpoints.DESVersion(includeCerts) + "/compare-skills-to-profession";
    }

    String desOntologySkillsSimilarityScore(boolean includeCerts) {
        return this._dataCenter.Url + "/ontology" + ApiEndpoints.DESVersion(includeCerts) + "/skills-similarity-score";
    }

    String jobDescriptionGenerate() {
        return this._dataCenter.Url + "/job-description/generate";
    }

    String jobDescriptionSuggestSkills() {
        return this._dataCenter.Url + "/job-description/suggest-skills";
    }

    String formatResume() {
        return this._dataCenter.Url + "/formatter/resume/template";
    }

    String matchV2CandidatesAddDocument(String documentId) {
        return this._dataCenter.Url + "/matchv2/candidates/" + documentId;
    }

    String matchV2CandidatesDeleteDocuments(List<String> documentIds, String env) {
        return String.format("%s/matchv2/candidates?ids=%s&SearchAndMatchEnvironment=%s", this._dataCenter.Url, String.join((CharSequence)",", documentIds), env);
    }

    String matchV2CandidatesSearch() {
        return this._dataCenter.Url + "/matchv2/candidates/search";
    }

    String matchV2CandidatesMatchDocument() {
        return this._dataCenter.Url + "/matchv2/candidates/match";
    }

    String matchV2CandidatesAutocomplete() {
        return this._dataCenter.Url + "/matchv2/candidates/autocomplete";
    }

    String matchV2JobsAddDocument(String documentId) {
        return this._dataCenter.Url + "/matchv2/vacancies/" + documentId;
    }

    String matchV2JobsDeleteDocuments(List<String> documentIds, String env) {
        return String.format("%s/matchv2/vacancies?ids=%s&SearchAndMatchEnvironment=%s", this._dataCenter.Url, String.join((CharSequence)",", documentIds), env);
    }

    String matchV2JobsSearch() {
        return this._dataCenter.Url + "/matchv2/vacancies/search";
    }

    String matchV2JobsMatchDocument() {
        return this._dataCenter.Url + "/matchv2/vacancies/match";
    }

    String matchV2JobsAutocomplete() {
        return this._dataCenter.Url + "/matchv2/vacancies/autocomplete";
    }
}

