/*
 * Decompiled with CFR 0.152.
 */
package com.traitify.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.sun.jersey.api.client.GenericType;
import com.traitify.models.AssessmentPersonalityTrait;
import com.traitify.models.AssessmentPersonalityTraitDichotomy;
import com.traitify.models.AssessmentPersonalityTypes;
import com.traitify.net.ApiModel;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JsonIgnoreProperties(ignoreUnknown=true)
public class Assessment
extends ApiModel {
    private String id;
    private String deck_id;
    private String user_id;
    private Date created_at;
    private Date completed_at;

    public static Assessment get(String assessment_id) {
        return (Assessment)Assessment.baseResource("assessments/" + assessment_id).get(Assessment.class);
    }

    public static Assessment create(String deck_id, String user_id) {
        Assessment assessment = new Assessment();
        assessment.setDeck_id(deck_id);
        assessment.setUser_id(user_id);
        return Assessment.create(assessment);
    }

    public static Assessment create(String deck_id) {
        Assessment assessment = new Assessment();
        assessment.setDeck_id(deck_id);
        return Assessment.create(assessment);
    }

    public static Assessment create(Assessment assessment) {
        return (Assessment)Assessment.baseResource("assessments").post(Assessment.class, (Object)assessment);
    }

    public static Assessment update(Assessment assessment) {
        return (Assessment)Assessment.baseResource("assessments/" + assessment.getId()).put(Assessment.class, (Object)assessment);
    }

    public static AssessmentPersonalityTypes personalityTypes(String assessment_id) {
        return (AssessmentPersonalityTypes)Assessment.baseResource("assessments/" + assessment_id + "/personality_types").get(AssessmentPersonalityTypes.class);
    }

    public static List<AssessmentPersonalityTrait> personalityTraits(String assessment_id, String personality_type_id) {
        return (List)Assessment.baseResource("assessments/" + assessment_id + "/personality_types/" + personality_type_id + "/personality_traits").get((GenericType)new GenericType<List<AssessmentPersonalityTrait>>(){});
    }

    public static List<AssessmentPersonalityTraitDichotomy> personalityTraits(String assessment_id) {
        return (List)Assessment.baseResource("assessments/" + assessment_id + "/personality_traits").get((GenericType)new GenericType<List<AssessmentPersonalityTraitDichotomy>>(){});
    }

    public static List<AssessmentPersonalityTrait> rawPersonalityTraits(String assessment_id) {
        return (List)Assessment.baseResource("assessments/" + assessment_id + "/personality_traits/raw").get((GenericType)new GenericType<List<AssessmentPersonalityTrait>>(){});
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDeck_id() {
        return this.deck_id;
    }

    public void setDeck_id(String deck_id) {
        this.deck_id = deck_id;
    }

    public String getUser_id() {
        return this.user_id;
    }

    public void setUser_id(String user_id) {
        this.user_id = user_id;
    }

    public Date getCreated_at() {
        return this.created_at;
    }

    public void setCreated_at(Date created_at) {
        this.created_at = created_at;
    }

    public Date getCompleted_at() {
        return this.completed_at;
    }

    public void setCompleted_at(Date completed_at) {
        this.completed_at = completed_at;
    }
}

