/*
 * Decompiled with CFR 0.152.
 */
package com.traitify.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.sun.jersey.api.client.GenericType;
import com.traitify.models.AssessmentData;
import com.traitify.models.AssessmentPersonalityTrait;
import com.traitify.models.AssessmentPersonalityTraitDichotomy;
import com.traitify.models.AssessmentPersonalityType;
import com.traitify.models.AssessmentPersonalityTypes;
import com.traitify.models.ImagePack;
import com.traitify.models.PersonalityBlend;
import com.traitify.models.ScoredCareer;
import com.traitify.models.Slide;
import com.traitify.net.ApiModel;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JsonIgnoreProperties(ignoreUnknown=true)
public class Assessment
extends ApiModel {
    private String id;
    private String deck_id;
    private String user_id;
    private Date created_at;
    private Date completed_at;
    private PersonalityBlend personality_blend;
    private List<AssessmentPersonalityType> personality_types;
    private List<AssessmentPersonalityTrait> personality_traits;
    private List<ScoredCareer> career_matches;
    private List<Slide> slides;

    public static Assessment create(String deck_id, String user_id) {
        Assessment assessment = new Assessment();
        assessment.setDeck_id(deck_id);
        assessment.setUser_id(user_id);
        return Assessment.create(assessment);
    }

    public static Assessment create(String deck_id) {
        Assessment assessment = new Assessment();
        assessment.setDeck_id(deck_id);
        return Assessment.create(assessment);
    }

    public static Assessment create(Assessment assessment) {
        return (Assessment)Assessment.baseResource("assessments").post(Assessment.class, (Object)assessment);
    }

    public static Assessment update(Assessment assessment) {
        return (Assessment)Assessment.baseResource("assessments/" + assessment.getId()).put(Assessment.class, (Object)assessment);
    }

    public static AssessmentPersonalityTypes personalityTypes(String assessment_id) {
        return (AssessmentPersonalityTypes)Assessment.baseResource("assessments/" + assessment_id + "/personality_types").get(AssessmentPersonalityTypes.class);
    }

    public static List<AssessmentPersonalityTrait> personalityTraits(String assessment_id, String personality_type_id) {
        return (List)Assessment.baseResource("assessments/" + assessment_id + "/personality_types/" + personality_type_id + "/personality_traits").get((GenericType)new GenericType<List<AssessmentPersonalityTrait>>(){});
    }

    public static List<AssessmentPersonalityTraitDichotomy> personalityTraits(String assessment_id) {
        return (List)Assessment.baseResource("assessments/" + assessment_id + "/personality_traits").get((GenericType)new GenericType<List<AssessmentPersonalityTraitDichotomy>>(){});
    }

    public static List<AssessmentPersonalityTrait> rawPersonalityTraits(String assessment_id) {
        return (List)Assessment.baseResource("assessments/" + assessment_id + "/personality_traits/raw").get((GenericType)new GenericType<List<AssessmentPersonalityTrait>>(){});
    }

    public static List<ScoredCareer> careerMatches(String assessment_id) {
        return Assessment.careerMatches(assessment_id, null, null);
    }

    public static List<ScoredCareer> careerMatches(String assessment_id, Integer number_of_matches) {
        return Assessment.careerMatches(assessment_id, number_of_matches, null);
    }

    public static List<ScoredCareer> careerMatches(String assessment_id, List<Integer> experience_levels) {
        return Assessment.careerMatches(assessment_id, null, experience_levels);
    }

    public static List<ScoredCareer> careerMatches(String assessment_id, Integer number_of_matches, List<Integer> experience_levels) {
        StringBuilder requestURL = new StringBuilder();
        requestURL.append("assessments/").append(assessment_id).append("/matches/careers?x=1");
        Assessment.appendCareerMatchOptions(number_of_matches, experience_levels, requestURL);
        return (List)Assessment.baseResource(requestURL.toString()).get((GenericType)new GenericType<List<ScoredCareer>>(){});
    }

    public static Assessment get(String assessment_id) {
        return Assessment.results(assessment_id, null);
    }

    public static Assessment results(String assessment_id, List<AssessmentData> data_to_return) {
        return Assessment.results(assessment_id, data_to_return, null);
    }

    public static Assessment results(String assessment_id, List<AssessmentData> data_to_return, ImagePack image_pack) {
        return Assessment.results(assessment_id, data_to_return, image_pack, null);
    }

    public static Assessment results(String assessment_id, List<AssessmentData> data_to_return, ImagePack image_pack, Integer number_of_matches) {
        return Assessment.results(assessment_id, data_to_return, image_pack, number_of_matches, null);
    }

    public static Assessment results(String assessment_id, List<AssessmentData> data_to_return, ImagePack image_pack, Integer number_of_matches, List<Integer> experience_levels) {
        StringBuilder requestURL = new StringBuilder();
        requestURL.append("assessments/").append(assessment_id).append("?x=1");
        if (data_to_return != null) {
            requestURL.append("&data=").append(Assessment.listToString(data_to_return));
        }
        if (image_pack != null) {
            requestURL.append("&image_pack=").append((Object)image_pack);
        }
        Assessment.appendCareerMatchOptions(number_of_matches, experience_levels, requestURL);
        return (Assessment)Assessment.baseResource(requestURL.toString()).get(Assessment.class);
    }

    private static void appendCareerMatchOptions(Integer number_of_matches, List<Integer> experience_levels, StringBuilder requestURL) {
        if (number_of_matches != null) {
            requestURL.append("&number_of_matches=").append(number_of_matches);
        }
        if (experience_levels != null) {
            requestURL.append("&experience_levels=").append(Assessment.listToString(experience_levels));
        }
    }

    private static String listToString(List<?> list) {
        StringBuilder sb = new StringBuilder();
        for (int x = 0; x < list.size(); ++x) {
            sb.append(list.get(x));
            if (x >= list.size()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDeck_id() {
        return this.deck_id;
    }

    public void setDeck_id(String deck_id) {
        this.deck_id = deck_id;
    }

    public String getUser_id() {
        return this.user_id;
    }

    public void setUser_id(String user_id) {
        this.user_id = user_id;
    }

    public Date getCreated_at() {
        return this.created_at;
    }

    public void setCreated_at(Date created_at) {
        this.created_at = created_at;
    }

    public Date getCompleted_at() {
        return this.completed_at;
    }

    public void setCompleted_at(Date completed_at) {
        this.completed_at = completed_at;
    }

    public PersonalityBlend getPersonality_blend() {
        return this.personality_blend;
    }

    public void setPersonality_blend(PersonalityBlend personality_blend) {
        this.personality_blend = personality_blend;
    }

    public List<AssessmentPersonalityType> getPersonality_types() {
        return this.personality_types;
    }

    public void setPersonality_types(List<AssessmentPersonalityType> personality_types) {
        this.personality_types = personality_types;
    }

    public List<AssessmentPersonalityTrait> getPersonality_traits() {
        return this.personality_traits;
    }

    public void setPersonality_traits(List<AssessmentPersonalityTrait> personality_traits) {
        this.personality_traits = personality_traits;
    }

    public List<ScoredCareer> getCareer_matches() {
        return this.career_matches;
    }

    public void setCareer_matches(List<ScoredCareer> career_matches) {
        this.career_matches = career_matches;
    }

    public List<Slide> getSlides() {
        return this.slides;
    }

    public void setSlides(List<Slide> slides) {
        this.slides = slides;
    }
}

