/*
 * Decompiled with CFR 0.152.
 */
package unquietcode.tools.flapi.plugin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import unquietcode.tools.flapi.Descriptor;
import unquietcode.tools.flapi.DescriptorMaker;
import unquietcode.tools.flapi.ExtractRuntime;
import unquietcode.tools.flapi.Flapi;
import unquietcode.tools.flapi.plugin.compile.CharSequenceJavaFileObject;
import unquietcode.tools.flapi.plugin.compile.ClassFileManager;

public abstract class PluginHelper {
    private final String classesDirectory;
    private final String sourcesDirectory;
    private boolean writeClasses = true;
    private boolean writeSources = true;
    private boolean includeRuntime = true;

    public PluginHelper(String classesDirectory, String sourcesDirectory) {
        this.classesDirectory = Objects.requireNonNull(classesDirectory, "classes directory is required");
        this.sourcesDirectory = Objects.requireNonNull(sourcesDirectory, "sources directory is required");
    }

    public void setWriteClasses(boolean writeClasses) {
        this.writeClasses = writeClasses;
    }

    public void setWriteSources(boolean writeSources) {
        this.writeSources = writeSources;
    }

    public void setIncludeRuntime(boolean includeRuntime) {
        this.includeRuntime = includeRuntime;
    }

    protected abstract Exception handleError(String var1, Throwable var2) throws Exception;

    protected abstract Exception handleFailure(String var1, Throwable var2) throws Exception;

    protected abstract void logInfo(String var1);

    protected abstract void logWarn(String var1);

    protected abstract void logError(String var1);

    protected Exception handleError(String message) throws Exception {
        return this.handleError(message, null);
    }

    protected Exception handleFailure(String message) throws Exception {
        return this.handleFailure(message, null);
    }

    protected abstract URLClassLoader getCompiledClassloader() throws Exception;

    private URLClassLoader classloader() throws Exception {
        try {
            return this.getCompiledClassloader();
        }
        catch (Exception ex) {
            throw this.handleError("could not load classes", ex);
        }
    }

    public void processDescriptors(Object ... descriptors) throws Exception {
        boolean atLeastOne = false;
        for (Object descriptor : descriptors) {
            Object descriptorClass;
            if (descriptor instanceof String) {
                descriptorClass = (String)descriptor;
                if (((String)(descriptorClass = ((String)descriptorClass).trim())).isEmpty() || ((String)descriptorClass).trim().equals("change.me")) continue;
                this.logInfo("processing descriptor " + (String)descriptorClass);
                this.processDescriptor((String)descriptorClass);
            } else if (descriptor instanceof Class) {
                descriptorClass = (Class)descriptor;
                this.logInfo("processing descriptor " + ((Class)descriptorClass).getName());
                this.processDescriptor(this.classloader(), (Class<?>)descriptorClass);
            } else if (DescriptorMaker.class.isAssignableFrom(descriptor.getClass())) {
                this.logInfo("processing descriptor");
                this.processDescriptor(this.classloader(), (DescriptorMaker)descriptor);
            } else if (Descriptor.class.isAssignableFrom(descriptor.getClass())) {
                this.logInfo("processing descriptor");
                this.processDescriptor(this.classloader(), (Descriptor)descriptor);
            } else {
                String message = "invalid descriptor object type: " + descriptor.getClass().getName();
                this.logError(message);
                throw this.handleError(message);
            }
            atLeastOne = true;
        }
        if (!atLeastOne) {
            this.logWarn("No descriptor classes were specified.");
        }
    }

    private void processDescriptor(String _descriptorClass) throws Exception {
        Class<?> descriptorClass;
        URLClassLoader classLoader = this.classloader();
        try {
            descriptorClass = classLoader.loadClass(_descriptorClass);
        }
        catch (Exception ex) {
            throw this.handleFailure("could not load class", ex);
        }
        this.processDescriptor(classLoader, descriptorClass);
    }

    private void processDescriptor(URLClassLoader classLoader, Class<?> descriptorClass) throws Exception {
        DescriptorMaker descriptorMaker;
        if (!DescriptorMaker.class.isAssignableFrom(descriptorClass)) {
            throw this.handleError("object must implement the DescriptorMaker interface");
        }
        try {
            descriptorMaker = (DescriptorMaker)descriptorClass.newInstance();
        }
        catch (Exception ex) {
            throw this.handleError("could not instantiate DescriptorMaker object", ex);
        }
        this.processDescriptor(classLoader, descriptorMaker);
    }

    private void processDescriptor(URLClassLoader classLoader, DescriptorMaker descriptorMaker) throws Exception {
        this.processDescriptor(classLoader, descriptorMaker.descriptor());
    }

    private void processDescriptor(URLClassLoader classLoader, Descriptor descriptor) throws Exception {
        if (descriptor == null) {
            throw this.handleError("method returned null");
        }
        if (this.writeClasses) {
            new File(this.classesDirectory).mkdirs();
            this.compileAndWriteClasses(descriptor, classLoader);
            if (this.includeRuntime) {
                ExtractRuntime.writeRequiredClasses((String)this.classesDirectory);
            }
        }
        if (this.writeSources) {
            new File(this.sourcesDirectory).mkdirs();
            descriptor.writeToFolder(this.sourcesDirectory);
            if (this.includeRuntime) {
                ExtractRuntime.writeRequiredSources((String)this.sourcesDirectory);
            }
        }
    }

    private List<JavaFileObject> getSourceFiles(Descriptor descriptor) {
        Map streams = descriptor.writeToStreams((Iterator)new Iterator<OutputStream>(){

            @Override
            public OutputStream next() {
                return new ByteArrayOutputStream();
            }

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("nope");
            }
        });
        ArrayList<JavaFileObject> files = new ArrayList<JavaFileObject>();
        for (Map.Entry entry : streams.entrySet()) {
            String name = (String)entry.getKey();
            name = name.substring(0, name.length() - 5);
            ByteArrayOutputStream stream = (ByteArrayOutputStream)entry.getValue();
            CharSequenceJavaFileObject file = new CharSequenceJavaFileObject(name, stream.toString());
            files.add(file);
        }
        return files;
    }

    private ClassLoader compileAndWriteClasses(Descriptor descriptor, URLClassLoader classLoader) throws Exception {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        ClassFileManager fileManager = new ClassFileManager(compiler.getStandardFileManager(null, null, null), this.classesDirectory);
        String jdkVersion = "1." + Flapi.getJDKVersion().ordinal();
        ArrayList<String> options = new ArrayList<String>();
        options.add("-classpath");
        options.add(PluginHelper.makeClasspath(classLoader));
        options.add("-source");
        options.add(jdkVersion);
        options.add("-target");
        options.add(jdkVersion);
        List<JavaFileObject> compilationUnits = this.getSourceFiles(descriptor);
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, options, null, compilationUnits);
        task.call();
        try {
            fileManager.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        boolean atLeastOneError = false;
        for (Diagnostic error : diagnostics.getDiagnostics()) {
            if (error.getKind() == Diagnostic.Kind.NOTE) continue;
            StringBuilder message = new StringBuilder().append(((JavaFileObject)error.getSource()).getName()).append(" (").append(error.getLineNumber()).append(",").append(error.getColumnNumber()).append(")\n").append(error.getMessage(Locale.getDefault()));
            this.logError(message.toString());
            atLeastOneError = true;
        }
        if (atLeastOneError) {
            throw this.handleError("The compilation was completed with errors.");
        }
        return fileManager.getClassLoader(StandardLocation.CLASS_PATH);
    }

    private static String makeClasspath(URLClassLoader classLoader) {
        StringBuilder buffer = new StringBuilder("\"");
        for (URL url : classLoader.getURLs()) {
            File file;
            try {
                file = new File(url.toURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            buffer.append(file);
            buffer.append(System.getProperty("path.separator"));
        }
        return buffer.append("\"").toString();
    }
}

