/*
 * Decompiled with CFR 0.152.
 */
package com.webpagebytes.authgitkit;

import com.google.identitytoolkit.GitkitClient;
import com.google.identitytoolkit.GitkitClientException;
import com.google.identitytoolkit.GitkitUser;
import com.webpagebytes.authgitkit.ConfigReader;
import com.webpagebytes.authgitkit.WPBDefaultAuthenticationResult;
import com.webpagebytes.cms.WPBAuthentication;
import com.webpagebytes.cms.WPBAuthenticationResult;
import com.webpagebytes.cms.exception.WPBException;
import com.webpagebytes.cms.exception.WPBIOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class WPBGitkitAuthentication
implements WPBAuthentication {
    public static final String TOKEN_COOKIE = "tokenCookie";
    public static final String LOGIN_PAGE_URL = "loginPageUrl";
    public static final String PROFILE_PAGE_URL = "profilePageUrl";
    public static final String LOGOUT_PAGE_URL = "logoutPageUrl";
    public static final String GITKIT_CLIENT_CONFIG_PATH = "gitkitClientConfigPath";
    public static final String ADMIN_EMAILS = "adminEmails";
    private Map<String, String> configs;
    private String tokenCookie;
    private String loginPageUrl;
    private String profilePageUrl;
    private String logoutPageUrl;
    private String gitkitClientConfigPath;
    private GitkitClient gitkitClient;
    private Set<String> adminEmails = new HashSet<String>();

    public void initialize(Map<String, String> params) throws WPBException {
        this.configs = ConfigReader.getConfigs();
        if (this.configs == null || this.configs.size() == 0) {
            throw new WPBException("No configs for WPBGitkitAuthentication");
        }
        this.tokenCookie = this.configs.get(TOKEN_COOKIE);
        this.loginPageUrl = this.configs.get(LOGIN_PAGE_URL);
        this.profilePageUrl = this.configs.get(PROFILE_PAGE_URL);
        this.logoutPageUrl = this.configs.get(LOGOUT_PAGE_URL);
        this.gitkitClientConfigPath = this.configs.get(GITKIT_CLIENT_CONFIG_PATH);
        if (this.tokenCookie == null || this.tokenCookie.length() == 0 || this.loginPageUrl == null || this.loginPageUrl.length() == 0 || this.profilePageUrl == null || this.profilePageUrl.length() == 0 || this.logoutPageUrl == null || this.logoutPageUrl.length() == 0 || this.gitkitClientConfigPath == null || this.gitkitClientConfigPath.length() == 0) {
            throw new WPBException("Bad configs for WPBGitkitAuthentication");
        }
        try {
            this.gitkitClient = GitkitClient.createFromJson((String)this.gitkitClientConfigPath);
        }
        catch (Exception e) {
            throw new WPBException("Error creating the GitkitClient", (Throwable)e);
        }
        String adminEmailsStr = this.configs.get(ADMIN_EMAILS);
        if (adminEmailsStr != null) {
            StringTokenizer tokenizer = new StringTokenizer(adminEmailsStr, ";, ");
            while (tokenizer.hasMoreElements()) {
                String email = tokenizer.nextToken();
                if (email.length() <= 0) continue;
                this.adminEmails.add(email);
            }
        }
    }

    public WPBAuthenticationResult checkAuthentication(HttpServletRequest request) throws WPBIOException {
        WPBDefaultAuthenticationResult result = new WPBDefaultAuthenticationResult();
        result.setLoginLink(this.loginPageUrl);
        result.setLogoutLink(this.logoutPageUrl);
        result.setUserProfileLink(this.profilePageUrl);
        try {
            GitkitUser gitkitUser = this.gitkitClient.validateTokenInRequest(request);
            if (null != gitkitUser && this.adminEmails.contains(gitkitUser.getEmail())) {
                result.setUserIdentifier(gitkitUser.getEmail());
            }
        }
        catch (GitkitClientException gitkitClientException) {
            // empty catch block
        }
        return result;
    }
}

