/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.document.processor.figlet;

import de.srsoftware.document.api.Document;
import de.srsoftware.document.processor.PipeProcessor;
import de.srsoftware.tools.Optionals;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class FigletDoc
extends PipeProcessor {
    @Override
    protected List<String> command(Map<String, Object> data) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("figlet");
        Object o = data.get("figlet");
        if (o instanceof Map) {
            Map config = (Map)o;
            Optionals.nullable(config.get("font")).filter(font -> font instanceof String).map(String.class::cast).filter(font -> !font.isBlank()).ifPresent(s -> list.addAll(List.of("-f", s)));
            Optionals.nullable(config.get("width")).filter(width -> width instanceof Integer).map(Integer.class::cast).ifPresent(w -> list.addAll(List.of("-w", "" + w)));
        }
        return list;
    }

    public String description() {
        return "Figlet text created from text file";
    }

    public String id() {
        return this.source().id().replace(".txt", ".figlet.txt");
    }

    public String mimeType() {
        return "text/plain";
    }

    protected abstract Document source();

    @Override
    public Duration timeout() {
        return Duration.ofSeconds(30L);
    }
}

