/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.document.processor.weasyprint;

import de.srsoftware.document.api.Document;
import de.srsoftware.document.processor.FileProcessor;
import java.io.File;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class WeasyDoc
extends FileProcessor {
    private static final String SOFTWARE = "weasyprint";

    @Override
    protected List<String> command(Map<String, Object> data) {
        ArrayList<String> command = new ArrayList<String>(10);
        command.add(SOFTWARE);
        Object object = data.get("additional_args");
        if (object instanceof List) {
            List args = (List)object;
            args.forEach(arg -> command.add(arg.toString()));
        }
        command.add(this.source().name());
        command.add(this.name());
        return command;
    }

    public String description() {
        return MessageFormat.format("PDF compiled from \"{0}\" via weasyprint", this.source().name());
    }

    public String id() {
        return new File(this.source().id()).getName() + ".pdf";
    }

    public String mimeType() {
        return "image/pdf";
    }

    @Override
    public String software() {
        return SOFTWARE;
    }

    protected abstract Document source();

    @Override
    public Duration timeout() {
        return Duration.ofSeconds(30L);
    }
}

