/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.compiler.plugin.parser;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.ArgumentAttr;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.DeferredAttr;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import java.util.function.Predicate;
import javax.tools.Diagnostic;
import net.binis.codegen.tools.Reflection;
import net.binis.codegen.tools.Tools;

public class CodeGenAttr
extends Attr {
    protected final Stack<JCTree.JCFieldAccess> _selects;
    protected final Stack<JCTree> _stack = new Stack();
    protected final Map<JCTree, JCTree.JCMethodInvocation> _rewritten = new HashMap<JCTree, JCTree.JCMethodInvocation>();
    protected static final Method TYPE_ENVS_GET = Reflection.findMethod((String)"get", (Class)Reflection.loadClass((String)"com.sun.tools.javac.comp.TypeEnvs"), (Class[])new Class[]{Symbol.TypeSymbol.class});
    protected static final Field TYPE_ENVS_FIELD = Reflection.findField(Attr.class, (String)"typeEnvs");
    protected static final Field MAKER_FIELD = Reflection.findField(Attr.class, (String)"make");
    protected static final Field ENV_FIELD = Reflection.findField(Attr.class, (String)"env");

    public static CodeGenAttr instance(Context ctx) {
        Attr attr = (Attr)ctx.get(attrKey);
        if (!(attr instanceof CodeGenAttr)) {
            ctx.put(attrKey, (Attr)null);
            attr = new CodeGenAttr(ctx);
        }
        return (CodeGenAttr)attr;
    }

    protected CodeGenAttr(Context context) {
        super(context);
        this._selects = new Stack();
        this.patchCompilerClasses(context);
    }

    protected void patchCompilerClasses(Context context) {
        Reflection.setFieldValue((Object)Resolve.instance(context), (String)"attr", (Object)this);
        Reflection.setFieldValue((Object)ArgumentAttr.instance(context), (String)"attr", (Object)this);
        Reflection.setFieldValue((Object)DeferredAttr.instance(context), (String)"attr", (Object)this);
        Reflection.setFieldValue((Object)JavaCompiler.instance(context), (String)"attr", (Object)this);
    }

    @Override
    public Type attribType(JCTree tree, Env<AttrContext> env) {
        return super.attribType(tree, env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitSelect(JCTree.JCFieldAccess tree) {
        this._selects.push(tree);
        try {
            DeferredAttrDiagHandler deferredAttrDiagHandler = this.suppressDiagnostics(tree);
            try {
                super.visitSelect(tree);
                Queue<JCDiagnostic> diag = deferredAttrDiagHandler.getDiagnostics();
                if (!diag.isEmpty()) {
                    int err = diag.size();
                    if (Tools.in((Object)diag.peek().getCode(), (Object[])new String[]{"compiler.err.cant.deref", "compiler.err.cant.resolve.location"})) {
                        if (this.tryToRewriteFieldAccess(tree, diag)) {
                            this.fixDiag(diag, err);
                        }
                    } else if (Tools.in((Object)diag.peek().getCode(), (Object[])new String[]{"compiler.err.doesnt.exist"})) {
                        JCTree.JCExpression jCExpression = tree.selected;
                        if (jCExpression instanceof JCTree.JCFieldAccess) {
                            JCTree.JCFieldAccess access = (JCTree.JCFieldAccess)jCExpression;
                            if (this.tryRewritePackage(tree)) {
                                this.fixDiag(diag, err);
                            }
                        } else {
                            JCTree.JCIdent ident;
                            jCExpression = tree.selected;
                            if (jCExpression instanceof JCTree.JCIdent && this.tryToRewriteIdent(ident = (JCTree.JCIdent)jCExpression) && this.tryToRewriteFieldAccess(tree, diag)) {
                                this.fixDiag(diag, err);
                            }
                        }
                    }
                }
            }
            finally {
                this.restoreDiagnostics(tree, deferredAttrDiagHandler);
            }
        }
        finally {
            this._selects.pop();
            if (this._selects.isEmpty()) {
                this._rewritten.clear();
            }
        }
    }

    protected void fixDiag(Queue<JCDiagnostic> diag, int err) {
        for (int i = 0; i < err; ++i) {
            diag.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitIdent(JCTree.JCIdent tree) {
        DeferredAttrDiagHandler deferredAttrDiagHandler = this.suppressDiagnostics(tree);
        try {
            super.visitIdent(tree);
            Queue<JCDiagnostic> diag = deferredAttrDiagHandler.getDiagnostics();
            if (!diag.isEmpty() && Tools.in((Object)diag.peek().getCode(), (Object[])new String[]{"compiler.err.cant.resolve.location"}) && this.tryToRewriteIdent(tree)) {
                diag.clear();
            }
        }
        finally {
            this.restoreDiagnostics(tree, deferredAttrDiagHandler);
        }
    }

    protected JCTree.JCMethodInvocation buildMethod(JCTree.JCExpression tree, Env env) {
        Type.MethodType mt = new Type.MethodType(List.nil(), Type.noType, List.nil(), ((Symtab)Reflection.getFieldValue((Object)this, (String)"syms")).methodClass);
        Object ri = Reflection.getFieldValue((Object)this, (String)"resultInfo");
        Reflection.setFieldValue((Object)ri, (String)"pt", (Object)mt);
        JCTree.JCMethodInvocation exp = this.getMaker().Apply(List.nil(), tree, List.nil());
        env.tree = exp;
        return exp;
    }

    protected boolean tryRewritePackage(JCTree.JCFieldAccess tree) {
        try {
            TreeMaker maker = this.getMaker();
            JCTree.JCExpression chain = this.tryRewritePackage(tree, null);
            chain = maker.Apply(List.nil(), maker.Select(chain, tree.name), List.nil());
            Env env = this.getEnv();
            Type type = this.attribExpr(chain, env);
            if (!type.isErroneous()) {
                env.tree = chain;
                tree.setType(type);
                return this.replaceTree(env.enclMethod.body, tree, (JCTree.JCMethodInvocation)chain);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected JCTree.JCExpression tryRewritePackage(JCTree.JCFieldAccess tree, JCTree.JCExpression chain) {
        try {
            JCTree.JCExpression jCExpression = tree.selected;
            if (jCExpression instanceof JCTree.JCFieldAccess) {
                JCTree.JCFieldAccess access = (JCTree.JCFieldAccess)jCExpression;
                TreeMaker maker = this.getMaker();
                chain = this.tryRewritePackage(access, chain);
                return maker.Apply(List.nil(), maker.Select(chain, access.name), List.nil());
            }
            Env env = this.getEnv();
            return this.buildMethod(tree.selected, env);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tryToRewriteFieldAccess(JCTree.JCFieldAccess tree, Queue<JCDiagnostic> diag) {
        try {
            Env env = this.getEnv();
            JCTree.JCMethodInvocation exp = this.buildMethod(tree, env);
            tree.sym = null;
            int prv = diag.size();
            super.visitSelect(tree);
            if (diag.size() == prv) {
                boolean bl = this.replaceTree(env.enclMethod.body, tree, exp);
                return bl;
            }
            diag.poll();
        }
        catch (Exception exception) {
        }
        finally {
            this._stack.clear();
        }
        return false;
    }

    protected boolean tryToRewriteIdent(JCTree.JCIdent tree) {
        try {
            Env env = this.getEnv();
            JCTree.JCMethodInvocation exp = this.buildMethod(tree, env);
            tree.sym = null;
            Type type = this.attribExpr(exp, env);
            if (!type.isErroneous()) {
                tree.setType(type);
                return this.replaceTree(env.enclMethod.body, tree, exp);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean replaceTree(JCTree old, JCTree tree, JCTree.JCMethodInvocation exp) {
        this._stack.push(old);
        try {
            if (old instanceof JCTree.JCBlock) {
                JCTree.JCBlock block = (JCTree.JCBlock)old;
                for (JCTree.JCStatement s : block.getStatements()) {
                    if (!this.replaceTree(s, tree, exp)) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            if (old instanceof JCTree.JCReturn) {
                JCTree.JCReturn ret = (JCTree.JCReturn)old;
                boolean result = this.replaceTree(ret.expr, tree, exp);
                if (ret.expr == tree) {
                    exp.type = ret.expr.type;
                    ret.expr = exp;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = result;
                return bl;
            }
            if (old instanceof JCTree.JCMethodInvocation) {
                JCTree.JCMethodInvocation invocation = (JCTree.JCMethodInvocation)old;
                JCTree.JCExpression jCExpression = invocation.meth;
                if (jCExpression instanceof JCTree.JCFieldAccess) {
                    JCTree.JCFieldAccess meth = (JCTree.JCFieldAccess)jCExpression;
                    if (meth.selected == tree) {
                        meth.selected = exp;
                        this._rewritten.put(tree, exp);
                        boolean bl = true;
                        return bl;
                    }
                    if (this._rewritten.containsValue(meth.selected)) {
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = this.replaceTree(meth.selected, tree, exp);
                    return bl;
                }
                boolean meth = false;
                return meth;
            }
            if (old instanceof JCTree.JCFieldAccess) {
                JCTree.JCFieldAccess access = (JCTree.JCFieldAccess)old;
                if (access.selected == tree) {
                    access.selected = exp;
                    this._rewritten.put(tree, exp);
                    boolean bl = true;
                    return bl;
                }
                JCTree.JCExpression jCExpression = access.selected;
                if (jCExpression instanceof JCTree.JCFieldAccess) {
                    JCTree.JCFieldAccess field = (JCTree.JCFieldAccess)jCExpression;
                    if (this._rewritten.containsKey(field)) {
                        field.selected = this._rewritten.get(field);
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = this.replaceTree(field, tree, exp);
                    return bl;
                }
                boolean bl = this.replaceTree(access.selected, tree, exp);
                return bl;
            }
            if (old instanceof JCTree.JCVariableDecl) {
                JCTree.JCVariableDecl variable = (JCTree.JCVariableDecl)old;
                if (variable.init == tree) {
                    if (Objects.nonNull(variable.vartype)) {
                        exp.type = variable.vartype.type;
                    } else if (Objects.nonNull(variable.type)) {
                        exp.type = variable.type;
                    } else {
                        JCTree.JCExpression jCExpression = variable.init;
                        if (jCExpression instanceof JCTree.JCFieldAccess) {
                            JCTree.JCFieldAccess access = (JCTree.JCFieldAccess)jCExpression;
                            if (Objects.nonNull(access.type)) {
                                exp.type = access.type.getReturnType();
                            }
                        }
                    }
                    variable.init = exp;
                    boolean access = true;
                    return access;
                }
                boolean access = this.replaceTree(variable.init, tree, exp);
                return access;
            }
            if (old instanceof JCTree.JCIf) {
                JCTree.JCIf _if = (JCTree.JCIf)old;
                boolean access = this.replaceTree(_if.cond, tree, exp) || this.replaceTree(_if.thenpart, tree, exp) || this.replaceTree(_if.elsepart, tree, exp);
                return access;
            }
            if (old instanceof JCTree.JCParens) {
                JCTree.JCParens parens = (JCTree.JCParens)old;
                boolean result = this.replaceTree(parens.expr, tree, exp);
                if (parens.expr == tree) {
                    exp.type = parens.expr.type.getReturnType();
                    parens.expr = exp;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = result;
                return bl;
            }
            if (old instanceof JCTree.JCBinary) {
                JCTree.JCBinary binary = (JCTree.JCBinary)old;
                if (binary.lhs == tree) {
                    exp.type = binary.lhs.type.getReturnType();
                    binary.lhs = exp;
                    Reflection.setFieldValue((Object)this, (String)"result", (Object)exp.type);
                    boolean result = true;
                    return result;
                }
                if (binary.rhs == tree) {
                    exp.type = binary.rhs.type.getReturnType();
                    binary.rhs = exp;
                    Reflection.setFieldValue((Object)this, (String)"result", (Object)exp.type);
                    boolean result = true;
                    return result;
                }
                boolean result = this.replaceTree(binary.lhs, tree, exp) || this.replaceTree(binary.rhs, tree, exp);
                return result;
            }
            if (old instanceof JCTree.JCExpressionStatement) {
                JCTree.JCExpressionStatement statement = (JCTree.JCExpressionStatement)old;
                boolean result = this.replaceTree(statement.expr, tree, exp);
                return result;
            }
            if (old instanceof JCTree.JCTry) {
                JCTree.JCTry _try = (JCTree.JCTry)old;
                boolean result = this.replaceTree(_try.body, tree, exp) || this.replaceTree(_try.finalizer, tree, exp);
                for (JCTree.JCCatch jCCatch : _try.catchers) {
                    result |= this.replaceTree(jCCatch, tree, exp);
                }
                for (JCTree jCTree : _try.resources) {
                    result |= this.replaceTree(jCTree, tree, exp);
                }
                boolean bl = result;
                return bl;
            }
            if (old instanceof JCTree.JCSwitchExpression) {
                JCTree.JCSwitchExpression _switch = (JCTree.JCSwitchExpression)old;
                boolean result = this.replaceTree(_switch.selector, tree, exp);
                for (JCTree.JCCase jCCase : _switch.cases) {
                    result |= this.replaceTree(jCCase, tree, exp);
                }
                boolean bl = result;
                return bl;
            }
            if (old instanceof JCTree.JCSwitch) {
                JCTree.JCSwitch _switch = (JCTree.JCSwitch)old;
                boolean result = this.replaceTree(_switch.selector, tree, exp);
                for (JCTree.JCCase jCCase : _switch.cases) {
                    result |= this.replaceTree(jCCase, tree, exp);
                }
                boolean bl = result;
                return bl;
            }
            if (old instanceof JCTree.JCCase) {
                JCTree.JCCase _case = (JCTree.JCCase)old;
                boolean result = this.replaceTree(_case.body, tree, exp);
                for (JCTree.JCStatement jCStatement : _case.stats) {
                    result |= this.replaceTree(jCStatement, tree, exp);
                }
                boolean bl = result;
                return bl;
            }
            if (old instanceof JCTree.JCYield) {
                JCTree.JCYield _yield = (JCTree.JCYield)old;
                boolean result = this.replaceTree(_yield.value, tree, exp);
                return result;
            }
            if (old instanceof JCTree.JCAssign) {
                JCTree.JCAssign assign = (JCTree.JCAssign)old;
                boolean result = this.replaceTree(assign.lhs, tree, exp) || this.replaceTree(assign.rhs, tree, exp);
                return result;
            }
            if (old instanceof JCTree.JCAssignOp) {
                JCTree.JCAssignOp assign = (JCTree.JCAssignOp)old;
                boolean result = this.replaceTree(assign.lhs, tree, exp) || this.replaceTree(assign.rhs, tree, exp);
                return result;
            }
            if (old instanceof JCTree.JCDoWhileLoop) {
                JCTree.JCDoWhileLoop loop = (JCTree.JCDoWhileLoop)old;
                boolean result = this.replaceTree(loop.body, tree, exp) || this.replaceTree(loop.cond, tree, exp);
                return result;
            }
            if (old instanceof JCTree.JCWhileLoop) {
                JCTree.JCWhileLoop loop = (JCTree.JCWhileLoop)old;
                boolean result = this.replaceTree(loop.body, tree, exp) || this.replaceTree(loop.cond, tree, exp);
                return result;
            }
            if (old instanceof JCTree.JCForLoop) {
                JCTree.JCForLoop loop = (JCTree.JCForLoop)old;
                boolean result = this.replaceTree(loop.body, tree, exp) || this.replaceTree(loop.cond, tree, exp);
                for (JCTree.JCStatement jCStatement : loop.init) {
                    result |= this.replaceTree(jCStatement, tree, exp);
                }
                for (JCTree.JCExpressionStatement jCExpressionStatement : loop.step) {
                    result |= this.replaceTree(jCExpressionStatement, tree, exp);
                }
                boolean bl = result;
                return bl;
            }
            if (old instanceof JCTree.JCEnhancedForLoop) {
                JCTree.JCEnhancedForLoop loop = (JCTree.JCEnhancedForLoop)old;
                boolean result = this.replaceTree(loop.body, tree, exp) || this.replaceTree(loop.expr, tree, exp);
                return result;
            }
            if (old instanceof JCTree.JCLambda) {
                JCTree.JCLambda lambda = (JCTree.JCLambda)old;
                boolean result = this.replaceTree(lambda.body, tree, exp);
                return result;
            }
            if (old instanceof JCTree.JCSynchronized) {
                JCTree.JCSynchronized sync = (JCTree.JCSynchronized)old;
                boolean result = this.replaceTree(sync.body, tree, exp) || this.replaceTree(sync.lock, tree, exp);
                return result;
            }
            if (old instanceof JCTree.JCConditional) {
                JCTree.JCConditional conditional = (JCTree.JCConditional)old;
                boolean result = this.replaceTree(conditional.cond, tree, exp) || this.replaceTree(conditional.truepart, tree, exp) || this.replaceTree(conditional.falsepart, tree, exp);
                return result;
            }
            if (old instanceof JCTree.JCThrow) {
                JCTree.JCThrow _throw = (JCTree.JCThrow)old;
                boolean result = this.replaceTree(_throw.expr, tree, exp);
                return result;
            }
            if (old instanceof JCTree.JCAssert) {
                JCTree.JCAssert _assert = (JCTree.JCAssert)old;
                boolean result = this.replaceTree(_assert.cond, tree, exp) || this.replaceTree(_assert.detail, tree, exp);
                return result;
            }
            if (old instanceof JCTree.JCInstanceOf) {
                JCTree.JCInstanceOf inst = (JCTree.JCInstanceOf)old;
                boolean result = this.replaceTree(inst.expr, tree, exp);
                return result;
            }
            if (old instanceof JCTree.JCCatch) {
                JCTree.JCCatch _catch = (JCTree.JCCatch)old;
                boolean result = this.replaceTree(_catch.body, tree, exp);
                return result;
            }
            if (old instanceof JCTree.JCUnary) {
                JCTree.JCUnary unary = (JCTree.JCUnary)old;
                boolean result = this.replaceTree(unary.arg, tree, exp);
                return result;
            }
            if (old instanceof JCTree.JCTypeCast) {
                JCTree.JCTypeCast cast = (JCTree.JCTypeCast)old;
                boolean result = this.replaceTree(cast.expr, tree, exp);
                return result;
            }
            if (old instanceof JCTree.JCNewClass) {
                JCTree.JCNewClass newClass = (JCTree.JCNewClass)old;
                boolean result = false;
                for (JCTree.JCExpression jCExpression : newClass.args) {
                    result |= this.replaceTree(jCExpression, tree, exp);
                }
                boolean bl = result;
                return bl;
            }
            if (old instanceof JCTree.JCNewArray) {
                JCTree.JCNewArray newArray = (JCTree.JCNewArray)old;
                boolean result = false;
                for (JCTree.JCExpression jCExpression : newArray.dims) {
                    result |= this.replaceTree(jCExpression, tree, exp);
                }
                if (Objects.nonNull(newArray.elems)) {
                    for (JCTree.JCExpression jCExpression : newArray.elems) {
                        result |= this.replaceTree(jCExpression, tree, exp);
                    }
                }
                boolean bl = result;
                return bl;
            }
            if (old instanceof JCTree.JCIdent) {
                JCTree.JCIdent ident = (JCTree.JCIdent)old;
                boolean bl = false;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this._stack.pop();
        }
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl tree) {
        super.visitVarDef(tree);
        tree.pos();
    }

    protected Log getLogger() {
        return (Log)Reflection.getFieldValue((Object)this, (String)"log");
    }

    protected DeferredAttrDiagHandler suppressDiagnostics(JCTree tree) {
        return new DeferredAttrDiagHandler(this.getLogger(), tree);
    }

    protected void restoreDiagnostics(JCTree tree, DeferredAttrDiagHandler deferredAttrDiagHandler) {
        Queue<JCDiagnostic> diagnostics = deferredAttrDiagHandler.getDiagnostics();
        if (!diagnostics.isEmpty()) {
            deferredAttrDiagHandler.reportDeferredDiagnostics();
        }
        this.getLogger().popDiagnosticHandler(deferredAttrDiagHandler);
    }

    protected Env getEnv() {
        return (Env)Reflection.getFieldValue((Field)ENV_FIELD, (Object)this);
    }

    protected TreeMaker getMaker() {
        return (TreeMaker)Reflection.getFieldValue((Field)MAKER_FIELD, (Object)this);
    }

    class DeferredAttrDiagHandler
    extends DeferredDiagnosticHandler {
        DeferredAttrDiagHandler(Log log, JCTree newTree) {
            super(log, (JCDiagnostic d) -> {
                PosScanner posScanner = new PosScanner(d.getDiagnosticPosition());
                posScanner.scan(newTree);
                return posScanner.found;
            });
        }

        static class PosScanner
        extends TreeScanner {
            JCDiagnostic.DiagnosticPosition pos;
            boolean found = false;

            PosScanner(JCDiagnostic.DiagnosticPosition pos) {
                this.pos = pos;
            }

            @Override
            public void scan(JCTree tree) {
                if (tree != null && tree.pos() == this.pos) {
                    this.found = true;
                }
                super.scan(tree);
            }
        }
    }

    class DeferredDiagnosticHandler
    extends Log.DiagnosticHandler {
        protected Queue<JCDiagnostic> deferred = new ListBuffer<JCDiagnostic>();
        protected final Predicate<JCDiagnostic> filter;

        public DeferredDiagnosticHandler(Log log) {
            this(log, null);
        }

        public DeferredDiagnosticHandler(Log log, Predicate<JCDiagnostic> filter) {
            this.filter = filter;
            this.install(log);
        }

        @Override
        public void report(JCDiagnostic diag) {
            if (!diag.isFlagSet(JCDiagnostic.DiagnosticFlag.NON_DEFERRABLE) && (this.filter == null || this.filter.test(diag))) {
                this.deferred.add(diag);
            } else {
                this.prev.report(diag);
            }
        }

        public Queue<JCDiagnostic> getDiagnostics() {
            return this.deferred;
        }

        public void reportDeferredDiagnostics() {
            this.reportDeferredDiagnostics(EnumSet.allOf(Diagnostic.Kind.class));
        }

        public void reportDeferredDiagnostics(Set<Diagnostic.Kind> kinds) {
            JCDiagnostic d;
            while ((d = this.deferred.poll()) != null) {
                if (!kinds.contains((Object)d.getKind())) continue;
                this.prev.report(d);
            }
            this.deferred = null;
        }
    }
}

