/*
 * Decompiled with CFR 0.152.
 */
package dev.mayuna.simpleapi;

import dev.mayuna.simpleapi.ApiRequestBuilder;
import dev.mayuna.simpleapi.PathParameter;
import dev.mayuna.simpleapi.RequestHeader;
import dev.mayuna.simpleapi.RequestMethod;
import dev.mayuna.simpleapi.RequestQuery;
import dev.mayuna.simpleapi.WrappedApi;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ApiRequest<T> {
    public static <T> ApiRequestBuilder<T> builder(WrappedApi wrappedApi, Class<T> responseClass) {
        return ApiRequestBuilder.ofResponse(wrappedApi, responseClass);
    }

    @NotNull
    public WrappedApi getWrappedApi();

    @NotNull
    public Class<T> getResponseClass();

    @Nullable
    public String getUrl();

    @NotNull
    public String getEndpoint();

    @NotNull
    public RequestMethod getRequestMethod();

    @Nullable
    default public PathParameter[] getPathParameters() {
        return null;
    }

    @Nullable
    default public RequestQuery[] getRequestQueries() {
        return null;
    }

    @Nullable
    default public RequestHeader[] getRequestHeaders() {
        return null;
    }

    @NonNull
    default public HttpRequest.BodyPublisher getBodyPublisher() {
        return HttpRequest.BodyPublishers.noBody();
    }

    @NotNull
    default public HttpResponse.BodyHandler<?> getBodyHandler() {
        return HttpResponse.BodyHandlers.ofString();
    }

    default public String getComputedEndpoint() {
        return this.getWrappedApi().computeEndpoint(this);
    }

    default public void applyHeadersToHttpRequestBuilder(HttpRequest.Builder httpRequestBuilder, RequestHeader[] requestHeaders) {
        this.getWrappedApi().applyHeadersToHttpRequestBuilder(this, httpRequestBuilder, requestHeaders);
    }

    default public HttpClient createHttpClientInstance() {
        return this.getWrappedApi().createHttpClientInstance();
    }

    default public HttpRequest.Builder createHttpRequestBuilderInstance() {
        return this.getWrappedApi().createHttpRequestBuilderInstance();
    }

    default public T createInstanceOfResponseClass() throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        return this.getWrappedApi().createInstanceOfResponseClass(this.getResponseClass());
    }

    default public T handleResponse(HttpResponse<?> httpResponse) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        return this.getWrappedApi().handleResponse(this, httpResponse);
    }

    default public CompletableFuture<T> sendAsync() {
        CompletableFuture completableFuture = new CompletableFuture();
        this.getWrappedApi().runAsync(() -> {
            try {
                completableFuture.complete(this.send());
            }
            catch (Throwable throwable) {
                completableFuture.completeExceptionally(throwable);
            }
        });
        return completableFuture;
    }

    default public T send() throws IOException, InterruptedException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        return this.getWrappedApi().send(this);
    }
}

