/*
 * Decompiled with CFR 0.152.
 */
package dev.mayuna.simpleapi;

import dev.mayuna.simpleapi.ApiRequest;
import dev.mayuna.simpleapi.ApiResponse;
import dev.mayuna.simpleapi.DeserializableApiResponse;
import dev.mayuna.simpleapi.PathParameter;
import dev.mayuna.simpleapi.RequestHeader;
import dev.mayuna.simpleapi.RequestQuery;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

public interface WrappedApi {
    public String getDefaultUrl();

    default public RequestHeader[] getDefaultRequestHeaders() {
        return null;
    }

    default public <T> String computeEndpoint(ApiRequest<T> apiRequest) {
        RequestQuery[] requestQueries;
        Object computedEndpoint = apiRequest.getEndpoint();
        PathParameter[] pathParameters = apiRequest.getPathParameters();
        if (pathParameters != null && pathParameters.length > 0) {
            for (PathParameter pathParameter : apiRequest.getPathParameters()) {
                computedEndpoint = ((String)computedEndpoint).replace("{" + pathParameter.getId() + "}", pathParameter.getReplacement());
            }
        }
        if ((requestQueries = apiRequest.getRequestQueries()) != null && requestQueries.length > 0) {
            for (int i = 0; i < requestQueries.length; ++i) {
                RequestQuery requestQuery = requestQueries[i];
                String querySymbol = "&";
                if (i == 0) {
                    querySymbol = "?";
                }
                computedEndpoint = (String)computedEndpoint + querySymbol + requestQuery.getName() + "=" + requestQuery.getValue();
            }
        }
        return computedEndpoint;
    }

    default public <T> void applyHeadersToHttpRequestBuilder(ApiRequest<T> apiRequest, HttpRequest.Builder httpRequestBuilder, RequestHeader[] requestHeaders) {
        RequestHeader[] defaultRequestHeaders;
        if (requestHeaders != null) {
            for (RequestHeader requestHeader : requestHeaders) {
                httpRequestBuilder.header(requestHeader.getKey(), requestHeader.getValue());
            }
        }
        if ((defaultRequestHeaders = apiRequest.getWrappedApi().getDefaultRequestHeaders()) != null) {
            for (RequestHeader defaultRequestHeader : defaultRequestHeaders) {
                httpRequestBuilder.header(defaultRequestHeader.getKey(), defaultRequestHeader.getValue());
            }
        }
    }

    default public HttpClient createHttpClientInstance() {
        return HttpClient.newBuilder().build();
    }

    default public HttpRequest.Builder createHttpRequestBuilderInstance() {
        return HttpRequest.newBuilder();
    }

    default public void runAsync(Runnable runnable) {
        new Thread(runnable).start();
    }

    default public <T> T createInstanceOfResponseClass(Class<T> responseClass) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        if (responseClass.isArray()) {
            throw new RuntimeException("Cannot create instance of array");
        }
        return responseClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    default public <T> T handleResponse(ApiRequest<T> apiRequest, HttpResponse<?> httpResponse) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        Object responseInstance = apiRequest.createInstanceOfResponseClass();
        if (responseInstance instanceof ApiResponse) {
            ApiResponse apiResponse = (ApiResponse)responseInstance;
            apiResponse.setHttpStatusCode(httpResponse.statusCode());
            apiResponse.setWrappedApi(apiRequest.getWrappedApi());
        }
        if (responseInstance instanceof DeserializableApiResponse) {
            responseInstance = ((DeserializableApiResponse)responseInstance).deserialize(apiRequest, httpResponse);
        }
        return responseInstance;
    }

    default public <T> T send(ApiRequest<T> apiRequest) throws IOException, InterruptedException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        T response;
        HttpResponse<?> httpResponse;
        String url = apiRequest.getUrl();
        if (url == null) {
            url = apiRequest.getWrappedApi().getDefaultUrl();
        }
        String requestUrl = url + apiRequest.getComputedEndpoint();
        HttpClient httpClient = this.createHttpClientInstance();
        HttpRequest.Builder httpRequestBuilder = this.createHttpRequestBuilderInstance();
        try {
            httpRequestBuilder.uri(new URI(requestUrl));
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            throw new RuntimeException("Invalid URI " + requestUrl, e);
        }
        apiRequest.applyHeadersToHttpRequestBuilder(httpRequestBuilder, apiRequest.getRequestHeaders());
        httpRequestBuilder.method(apiRequest.getRequestMethod().getName(), apiRequest.getBodyPublisher());
        apiRequest.getWrappedApi().onApiRequest(apiRequest);
        try {
            httpResponse = httpClient.send(httpRequestBuilder.build(), apiRequest.getBodyHandler());
        }
        catch (Throwable throwable) {
            apiRequest.getWrappedApi().onException(apiRequest, throwable);
            if (apiRequest.getWrappedApi().rethrowExceptions()) {
                throw throwable;
            }
            return null;
        }
        apiRequest.getWrappedApi().onAfterApiRequest(apiRequest);
        try {
            response = apiRequest.handleResponse(httpResponse);
        }
        catch (Throwable throwable) {
            apiRequest.getWrappedApi().onException(apiRequest, throwable);
            if (apiRequest.getWrappedApi().rethrowExceptions()) {
                throw throwable;
            }
            return null;
        }
        apiRequest.getWrappedApi().onAfterHandledApiRequest(apiRequest, response);
        return response;
    }

    default public <T> void onApiRequest(ApiRequest<T> request) {
    }

    default public <T> void onAfterApiRequest(ApiRequest<T> request) {
    }

    default public <T> void onAfterHandledApiRequest(ApiRequest<T> request, T response) {
    }

    default public <T> void onException(ApiRequest<T> request, Throwable throwable) {
    }

    default public boolean rethrowExceptions() {
        return true;
    }
}

